/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.variant.ConstProfile;
import pyrosim.domain.variant.DefaultProfile;
import pyrosim.domain.variant.FractionalRampProfile;
import pyrosim.domain.variant.IRampProfile;
import pyrosim.domain.variant.IVarTypeProfile;
import pyrosim.domain.variant.Variant;
import pyrosim.domain.variant.VariantProfile;
import pyrosim.gui.RampFuncDlg;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Comm;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class VariantEditor {
    public static final String DEFAULT = "Default :";
    public static final String RAMP = "Custom :";
    public static final String TANH = "Tanh";
    public static final String TSQUARED = "<html>t<sup>2</sup></html>";
    private guiComboBox<String> d_combo;
    private guiLabel d_rampLab;
    private String d_valDesc;
    private guiCheckBox d_cb;
    private Hashtable d_tipTable = null;
    private final guiPanel d_cardPanel;
    private Map<String, ValueField> d_fldMap;
    private Map<String, IVarTypeProfile> d_varProfiles;
    private Map<String, RampAction> d_rampMap;
    private Map<String, FracRampAction> d_fracRampMap;
    private Map<String, JButton> d_buttons;
    private final CardLayout d_cards;
    private final String d_strId;
    private final VariantProfile d_varProfile;

    public VariantEditor(String label, String valDesc, VariantProfile varProf) {
        this(label, valDesc, varProf, false);
    }

    public VariantEditor(String label, VariantProfile varProf, boolean useCheckBox) {
        this(label, label, varProf, useCheckBox);
    }

    public VariantEditor(String label, String valDesc, VariantProfile varProf, boolean useCheckBox) {
        this.d_strId = label;
        this.d_valDesc = valDesc;
        this.d_varProfile = varProf;
        this.d_combo = new guiComboBox();
        final ListCellRenderer originalRenderer = this.d_combo.getRenderer();
        this.d_combo.setRenderer(new ListCellRenderer<String>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
                String localizedValue = Intl.intl(value);
                return originalRenderer.getListCellRendererComponent(list, localizedValue, index, isSelected, cellHasFocus);
            }
        });
        this.d_combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                VariantEditor.this.d_cards.show(VariantEditor.this.d_cardPanel, VariantEditor.this.d_combo.getSelectedItem());
            }
        });
        this.d_fldMap = new HashMap<String, ValueField>();
        this.d_varProfiles = new HashMap<String, IVarTypeProfile>();
        this.d_rampMap = new HashMap<String, RampAction>();
        this.d_fracRampMap = new HashMap<String, FracRampAction>();
        this.d_buttons = new HashMap<String, JButton>();
        this.d_rampLab = new guiLabel(label + ":");
        this.d_cards = new CardLayout();
        this.d_cardPanel = new guiPanel(this.d_cards);
        if (useCheckBox) {
            this.d_cb = new guiCheckBox(label);
            LinkStatus.link((AbstractButton)this.d_cb, this.getComponents());
        }
        for (IVarTypeProfile typeProf : varProf.getAllowableTypes()) {
            this.addComboOption(typeProf);
        }
        this.d_combo.setMinimumSize(this.d_combo.getPreferredSize());
    }

    private void addComboOption(IVarTypeProfile typeProf) {
        guiPanel card;
        String comboOption = typeProf.getDisplayName();
        Variant defVal = typeProf.getDefaultValue();
        this.d_combo.add(comboOption);
        if (typeProf instanceof DefaultProfile) {
            card = new guiPanel();
        } else if (typeProf instanceof ConstProfile) {
            UnitDouble dbl = (UnitDouble)defVal.val;
            IUnitSrc usrc = UnitSystem.getSource(((ConstProfile)typeProf).unitType);
            ValueField<UnitDouble> fld = ValueFields.udFld(usrc);
            fld.setValue(dbl);
            card = new guiPanel(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(card, false);
            gbh.addRow(fld);
            if (this.d_cb != null) {
                LinkStatus.link((AbstractButton)this.d_cb, fld);
            }
            this.d_fldMap.put(comboOption, fld);
        } else if (typeProf instanceof IRampProfile) {
            RampBtn btn;
            card = new guiPanel(new GridBagLayout());
            if (typeProf instanceof FractionalRampProfile) {
                action = new FracRampAction(this.d_strId + ":", this.d_valDesc, (FractionalRampProfile)typeProf);
                this.d_fracRampMap.put(comboOption, (FracRampAction)action);
                btn = new RampBtn(card.getComm(), action);
            } else {
                action = new RampAction(this.d_valDesc, (IRampProfile)typeProf);
                this.d_rampMap.put(comboOption, (RampAction)action);
                btn = new RampBtn(card.getComm(), action);
            }
            GridBagHelper gbh = new GridBagHelper(card, false);
            gbh.addRow(btn);
            if (this.d_cb != null) {
                LinkStatus.link((AbstractButton)this.d_cb, btn);
            }
            this.d_buttons.put(comboOption, btn);
            btn.addActionListener(card.getComm());
        } else {
            card = new guiPanel();
        }
        this.d_cardPanel.add((Component)card, comboOption);
        this.d_varProfiles.put(comboOption, typeProf);
    }

    public void addToPanel(guiPanel panel, int beginCol, int beginRow, int top, int left, int bottom, int right) {
        GridBagUtil.add(panel, this.getVisLabel(), beginCol + 0, beginRow, 1, 1, top, left, bottom, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getCombo(), beginCol + 1, beginRow, 1, 1, top, 0, bottom, 6, 2, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getEditor(), beginCol + 2, beginRow, 1, 1, top, 0, bottom, right, 2, 0.0, 0.0, 17);
        panel.validate();
    }

    public void addToPanel(guiPanel panel) {
        GridBagHelper gb = new GridBagHelper(panel, true);
        this.addToPanel(gb);
        gb.finalizeRows();
    }

    public void addToPanel(GridBagHelper gbh) {
        gbh.addRow(this.getLabel(), this.getCombo(), this.getEditor());
    }

    public void addToPanel(GridBagHelper gbh, GridBagHelper.Fill lblFill, GridBagHelper.Fill comboFill, GridBagHelper.Fill editorFill) {
        gbh.addRow(new Object[]{this.getLabel(), lblFill, this.getCombo(), comboFill, this.getEditor(), editorFill, 0});
    }

    public String getStrLabel() {
        return this.d_strId;
    }

    public boolean validateData(boolean showWarn, boolean allowModify) {
        String selectedItem = this.d_combo.getSelectedItem();
        IVarTypeProfile type = this.d_varProfiles.get(selectedItem);
        if (type instanceof FractionalRampProfile) {
            Ramp r;
            FracRampAction action = this.d_fracRampMap.get(selectedItem);
            JButton button = this.d_buttons.get(selectedItem);
            JComponent comp = button != null ? button : this.d_combo;
            if (!this.validateRamp(showWarn, allowModify, comp, r = action.getRamp())) {
                return false;
            }
        } else if (type instanceof IRampProfile) {
            Ramp r;
            RampAction action = this.d_rampMap.get(selectedItem);
            JButton button = this.d_buttons.get(selectedItem);
            JComponent comp = button != null ? button : this.d_combo;
            if (!this.validateRamp(showWarn, allowModify, comp, r = action.getRamp())) {
                return false;
            }
        }
        return true;
    }

    private boolean validateRamp(boolean showWarn, boolean allowModify, Component comp, Ramp r) {
        if (r.isEmpty() && comp.isEnabled() && comp.isVisible()) {
            if (showWarn) {
                Window parentComponent = SwingUtilities.getWindowAncestor(comp);
                String msg = String.format(Intl.intl("Custom %s table must not be empty."), this.d_valDesc);
                JOptionPane.showMessageDialog(parentComponent, msg, Intl.intl("Ramp Error"), 0);
            }
            if (allowModify) {
                comp.requestFocus();
            }
            return false;
        }
        return true;
    }

    public Variant getValue() {
        Variant var = null;
        String selectedItem = this.d_combo.getSelectedItem();
        IVarTypeProfile type = this.d_varProfiles.get(selectedItem);
        if (type instanceof DefaultProfile) {
            var = Variant.DEFAULT;
        } else if (type instanceof ConstProfile) {
            ValueField fld = this.d_fldMap.get(selectedItem);
            var = Variant.constant((UnitDouble)fld.getValue());
        } else if (type instanceof FractionalRampProfile) {
            FracRampAction action = this.d_fracRampMap.get(selectedItem);
            var = Variant.fracRamp(action.getConst(), action.getRamp());
        } else if (type instanceof IRampProfile) {
            RampAction action = this.d_rampMap.get(selectedItem);
            var = Variant.ramp(action.getRamp());
        }
        return var;
    }

    private void init(String sel) {
        this.init(sel, true);
    }

    private void init(String sel, boolean enabled) {
        this.d_combo.setSelectedItem(sel);
        if (this.d_cb != null) {
            this.d_cb.setSelected(enabled);
        }
    }

    public boolean init(Variant v) {
        return this.init(v, true);
    }

    public boolean init(Variant v, boolean enabled) {
        Variant.Type type = v.getType();
        for (Map.Entry<String, IVarTypeProfile> entry : this.d_varProfiles.entrySet()) {
            if (entry.getValue().getType() != type) continue;
            this.editComboOption(entry.getKey(), v);
            this.init(entry.getKey(), enabled);
            return true;
        }
        return false;
    }

    private void editComboOption(String comboOption, Variant var) {
        this.d_varProfiles.get(comboOption);
        if (var.isConstant()) {
            ValueField fld = this.d_fldMap.get(comboOption);
            fld.setValue((UnitDouble)var.val);
        } else if (var.isRamp()) {
            RampAction action = this.d_rampMap.get(comboOption);
            action.setRamp((Ramp)var.val);
        } else if (var.isFractionalRamp()) {
            FracRampAction action = this.d_fracRampMap.get(comboOption);
            Variant.FractionalRamp fr = (Variant.FractionalRamp)var.val;
            action.setRamp(fr.fractionalRamp);
            action.setConst(fr.constInput);
        }
    }

    public Component getVisLabel() {
        return this.d_cb == null ? this.getLabel() : this.getCheckBox();
    }

    public guiLabel getLabel() {
        return this.d_rampLab;
    }

    public guiCheckBox getCheckBox() {
        return this.d_cb;
    }

    public guiComboBox getCombo() {
        return this.d_combo;
    }

    public guiPanel getEditor() {
        return this.d_cardPanel;
    }

    public boolean isEnabled() {
        if (this.d_cb == null) {
            return true;
        }
        return this.d_cb.isSelected();
    }

    public void setToolTipLookUp(Hashtable h) {
        this.d_tipTable = h;
    }

    public Component[] getComponents() {
        ArrayList<JComponent> items = new ArrayList<JComponent>();
        items.add(this.d_combo);
        items.add(this.d_rampLab);
        items.addAll(this.d_fldMap.values());
        items.addAll(this.d_buttons.values());
        Component[] comps = new Component[items.size()];
        return items.toArray(comps);
    }

    private static class FracRampAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private static final String PROP_RAMP = "ramp";
        private static final String PROP_CONST = "const";
        private final String d_rampValDesc;
        private final String d_constValDesc;
        private final FractionalRampProfile d_rampProfile;

        public FracRampAction(String constDesc, String rampDesc, FractionalRampProfile profile) {
            super(Intl.intl("Edit Values") + "...");
            this.d_constValDesc = constDesc;
            this.d_rampValDesc = rampDesc;
            this.d_rampProfile = profile;
            Variant.FractionalRamp fr = (Variant.FractionalRamp)this.d_rampProfile.getDefaultValue().val;
            this.setRamp(fr.fractionalRamp);
            this.setConst(fr.constInput);
        }

        public void setRamp(Ramp r) {
            this.putValue(PROP_RAMP, r);
        }

        public Ramp getRamp() {
            return (Ramp)this.getValue(PROP_RAMP);
        }

        public void setConst(UnitDouble ud) {
            this.putValue(PROP_CONST, ud);
        }

        public UnitDouble getConst() {
            return (UnitDouble)this.getValue(PROP_CONST);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UnitDouble oldConst = this.getConst();
            Ramp oldRamp = this.getRamp();
            RampFuncDlg rampDlg = new RampFuncDlg(oldRamp.getDefaultInput(), oldRamp.getFUnitType(), this.d_rampValDesc, this.d_rampProfile.getRampInputs(PyroSim.getApp().getMediator()), this.d_rampProfile.constUnitType, this.d_constValDesc);
            rampDlg.loadData(oldRamp);
            rampDlg.loadData(oldConst);
            if (rampDlg.doModal() == 1) {
                UnitDouble postConst;
                Ramp postRamp = rampDlg.getRamp();
                if (!theUtil.equal(oldRamp, postRamp)) {
                    this.setRamp(postRamp);
                }
                if (!theUtil.equal(oldConst, postConst = rampDlg.getConstVal())) {
                    this.setConst(postConst);
                }
            }
        }
    }

    private static class RampBtn
    extends JButton
    implements Modifiable,
    PropertyChangeListener {
        private static final long serialVersionUID = -3340702741932652669L;
        private final Comm d_comm;
        private boolean d_modified = false;

        public RampBtn(Comm comm, Action action) {
            super(action);
            this.d_comm = comm;
            action.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ramp")) {
                this.setModified(true);
                this.d_comm.touch(evt);
            }
        }

        @Override
        public boolean isModified() {
            return this.d_modified;
        }

        @Override
        public void setModified(boolean modified) {
            this.d_modified = modified;
        }
    }

    private static class RampAction
    extends AbstractAction {
        private static final long serialVersionUID = 961933547288309311L;
        private static final String PROP_RAMP = "ramp";
        private final String d_valDesc;
        private final IRampProfile d_rampType;

        public RampAction(String valDesc, IRampProfile rampType) {
            super(Intl.intl("Edit Values") + "...");
            this.d_valDesc = valDesc;
            this.d_rampType = rampType;
            this.setRamp((Ramp)rampType.getDefaultValue().val);
        }

        public void setRamp(Ramp r) {
            this.putValue(PROP_RAMP, r);
        }

        public Ramp getRamp() {
            return (Ramp)this.getValue(PROP_RAMP);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Ramp postRamp;
            Ramp oldRamp = this.getRamp();
            RampFuncDlg rampDlg = new RampFuncDlg(oldRamp.getDefaultInput(), oldRamp.getFUnitType(), this.d_valDesc, this.d_rampType.getRampInputs(PyroSim.getApp().getMediator()));
            rampDlg.loadData(oldRamp);
            if (rampDlg.doModal() == 1 && !theUtil.equal(oldRamp, postRamp = rampDlg.getRamp())) {
                this.setRamp(postRamp);
            }
        }
    }
}

