/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.io.TimeHistoryData;
import thunderheadeng.gui.Graph;
import thunderheadeng.gui.Series;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiFrame;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.util.FileFilters;

public class TimeHistoryPlotDlg
extends guiFrame {
    private static final long serialVersionUID = -3930005600781236822L;
    private static final Color LINE_COLOR = new Color(0, 64, 128);
    private TimeHistoryData d_data;
    private final Graph d_graph;
    private final JList d_list;
    private int d_showindex;

    public TimeHistoryPlotDlg(JFrame owner, TimeHistoryData data) {
        super("Time History Plots");
        super.setResizable(true);
        this.d_showindex = 0;
        this.d_data = data;
        this.d_list = new JList(new ListData());
        this.d_list.addListSelectionListener(new ListReactor());
        this.d_graph = new Graph();
        this.d_graph.setPreferredSize(new Dimension(500, 400));
        Container content = super.getContentPane();
        content.setLayout(new BorderLayout());
        JSplitPane pane = new JSplitPane(1, this.buildNav(), this.buildVis());
        content.add((Component)pane, "Center");
        ImageIcon ico = PyroGuiUtil.loadPyroSimIcon("PyroSimIcon16.png");
        this.setIconImage(ico.getImage());
        this.setJMenuBar(this.buildMenuBar());
        this.setDialogName();
        this.d_list.setSelectedIndex(0);
        this.pack();
        this.center();
    }

    private JMenuBar buildMenuBar() {
        JMenuBar bar = new JMenuBar();
        guiMenu fileMenu = new guiMenu(Intl.intl("File"));
        fileMenu.add((Action)new RefreshAction());
        fileMenu.add((Action)new ExportAction());
        bar.add(fileMenu);
        return bar;
    }

    private Container buildNav() {
        JScrollPane jsp = new JScrollPane(this.d_list);
        jsp.setVerticalScrollBarPolicy(22);
        Dimension prefSize = jsp.getPreferredSize();
        jsp.setMinimumSize(new Dimension(prefSize));
        prefSize.width = Math.max(100, prefSize.width);
        jsp.setPreferredSize(prefSize);
        return jsp;
    }

    private Container buildVis() {
        return this.d_graph;
    }

    private void setDialogName() {
        Object title = "";
        String filename = PyroSim.getApp().getFilename();
        if (filename == null) {
            title = (String)title + "Untitled";
        } else {
            int idx = filename.lastIndexOf(System.getProperty("file.separator"));
            title = (String)title + filename.substring(idx + 1, filename.length());
        }
        title = (String)title + " - " + this.getTitle();
        this.setTitle((String)title);
    }

    public void showDataFor(int index) {
        this.d_graph.reset();
        String label = this.d_data.getLabels().get(index + 1);
        String quantityX = this.d_data.getQuantities().get(0);
        String quantityY = this.d_data.getQuantities().get(index + 1);
        String unitsX = this.d_data.getUnits().get(0);
        String unitsY = this.d_data.getUnits().get(index + 1);
        this.d_graph.setTitle(label);
        this.d_graph.setXTitle(quantityX + " (" + unitsX + ")");
        this.d_graph.setYTitle(quantityY + " (" + unitsY + ")");
        int n = this.d_data.getNumValues();
        double[] xs = new double[n];
        double[] ys = new double[n];
        double minx = Double.MAX_VALUE;
        double maxx = -1.7976931348623157E308;
        double miny = Double.MAX_VALUE;
        double maxy = -1.7976931348623157E308;
        for (int i = 0; i < n; ++i) {
            xs[i] = this.d_data.getValues(i).get(0);
            ys[i] = this.d_data.getValues(i).get(index + 1);
            minx = Math.min(minx, xs[i]);
            maxx = Math.max(maxx, xs[i]);
            miny = Math.min(miny, ys[i]);
            maxy = Math.max(maxy, ys[i]);
        }
        Series s = new Series(xs, ys, label, LINE_COLOR, 13, 0, 3);
        this.d_graph.addSeries(s);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                TimeHistoryPlotDlg.this.d_graph.repaint();
            }
        });
    }

    private class ListData
    extends AbstractListModel {
        private static final long serialVersionUID = -1892703556290673639L;

        private ListData() {
        }

        @Override
        public int getSize() {
            return TimeHistoryPlotDlg.this.d_data.getLabels().size() - 1;
        }

        @Override
        public Object getElementAt(int index) {
            return TimeHistoryPlotDlg.this.d_data.getLabels().get(index + 1);
        }
    }

    private class ListReactor
    implements ListSelectionListener {
        private ListReactor() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TimeHistoryPlotDlg.this.d_showindex = TimeHistoryPlotDlg.this.d_list.getSelectedIndex();
            TimeHistoryPlotDlg.this.showDataFor(TimeHistoryPlotDlg.this.d_showindex);
        }
    }

    private class RefreshAction
    extends guiAction {
        private static final long serialVersionUID = -4835775713376103652L;

        public RefreshAction() {
            super(Intl.intl("Refresh"));
            this.addAccelerator(KeyStroke.getKeyStroke(116, 0));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                TimeHistoryData refreshData;
                TimeHistoryPlotDlg.this.d_data = refreshData = TimeHistoryPlotDlg.this.d_data.refresh();
                TimeHistoryPlotDlg.this.showDataFor(TimeHistoryPlotDlg.this.d_list.getSelectedIndex());
            }
            catch (Throwable t) {
                guiUtil.showError(TimeHistoryPlotDlg.this, Intl.intl("CSV Error"), Intl.intl("Error Reading CSV File"), t);
            }
        }
    }

    private class ExportAction
    extends guiAction {
        private static final long serialVersionUID = 4043590402228677578L;

        public ExportAction() {
            super(Intl.intl("Image Capture..."));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            guiJFXFileChooser chooser = new guiJFXFileChooser("untitled.png", PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_PNG);
            File f = chooser.showSaveDialog();
            if (f == null) {
                return;
            }
            PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
            BufferedImage img = new BufferedImage(TimeHistoryPlotDlg.this.d_graph.getWidth(), TimeHistoryPlotDlg.this.d_graph.getHeight(), 2);
            Graphics2D g2d = img.createGraphics();
            TimeHistoryPlotDlg.this.d_graph.paint(g2d);
            g2d.dispose();
            try {
                if (f.getName().toLowerCase().endsWith(".png")) {
                    ImageIO.write((RenderedImage)img, "png", f);
                } else {
                    ImageIO.write((RenderedImage)img, "png", new File(f.getPath() + ".png"));
                }
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(TimeHistoryPlotDlg.this, Intl.intl("Error saving image: ") + ex.getMessage());
            }
        }
    }
}

