/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.RampInputs;
import pyrosim.gui.RampFuncDlg;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.theUtil;

public class TimeFunctionEditor {
    public final int IX_DEFAULT;
    public final int IX_AUTO;
    public final int IX_TANH;
    public final int IX_TSQUARED;
    public final int IX_FROM_TABLE;
    public static final int DEFAULT = 1;
    public static final int AUTO = 2;
    public static final int TANH = 4;
    public static final int TSQUARED = 8;
    public static final int CUSTOM = 16;
    public static final String STR_DEFAULT = Intl.intl("Default");
    public static final String STR_AUTO = Intl.intl("Automatic");
    public static final String STR_TANH = Intl.intl("Tanh");
    public static final String STR_TSQUARED = Intl.intl("<html>t<sup>2</sup></html>");
    public static final String STR_CUSTOM = Intl.intl("Custom");
    private guiComboBox<String> d_combo;
    private final String d_label;
    private guiLabel d_rampLab;
    private ValueField<UnitDouble> d_tanhFld;
    private ValueField<UnitDouble> d_tsquaredFld;
    private ValueField<UnitDouble> d_defaultFld;
    private ValueField<UnitDouble> d_autoFld;
    private JButton d_button;
    private guiPanel d_panel;
    private Hashtable d_tipTable = null;
    private RampAction d_rampAction;

    public TimeFunctionEditor(String label, int comboOptions) {
        int comboIndex = 0;
        this.d_label = label;
        this.d_combo = new PreFireComboBox();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.d_rampLab = new guiLabel(label + ":");
        this.d_tanhFld = ValueFields.udFld(UnitSystem.getSource(2), UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_tsquaredFld = ValueFields.udFld(UnitSystem.getSource(2), UnitDoubleVR.above(0.0, SI.SECOND, true));
        this.d_defaultFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_autoFld = ValueFields.udFld(UnitSystem.getSource(2));
        this.d_defaultFld.setEditable(false);
        this.d_autoFld.setEditable(false);
        this.d_button = new JButton(Intl.intl("Edit Values") + "...");
        this.d_defaultFld.setValue((UnitDouble)TimeFunction.newDefault().val);
        this.d_tanhFld.setValue(new TimeFunction.TanH().val);
        this.d_tsquaredFld.setValue(new TimeFunction.TSquared().val);
        Dimension d = this.d_defaultFld.getPreferredSize();
        d.width = this.d_button.getPreferredSize().width;
        this.d_tanhFld.setPreferredSize(d);
        this.d_tsquaredFld.setPreferredSize(d);
        this.d_defaultFld.setPreferredSize(d);
        this.d_autoFld.setPreferredSize(d);
        this.d_button.setPreferredSize(d);
        this.d_panel = new guiPanel(gbl);
        this.d_rampAction = new RampAction(this.d_panel);
        this.d_button.addActionListener(this.d_rampAction);
        if ((comboOptions & 1) != 0) {
            this.d_defaultFld.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_DEFAULT);
            this.IX_DEFAULT = comboIndex++;
            this.d_panel.add(this.d_defaultFld, gbc);
        } else {
            this.IX_DEFAULT = -1;
        }
        if ((comboOptions & 2) != 0) {
            this.d_autoFld.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_AUTO);
            this.IX_AUTO = comboIndex++;
            this.d_panel.add(this.d_autoFld, gbc);
        } else {
            this.IX_AUTO = -1;
        }
        if ((comboOptions & 4) != 0) {
            this.d_tanhFld.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_TANH);
            this.IX_TANH = comboIndex++;
            this.d_panel.add(this.d_tanhFld, gbc);
        } else {
            this.IX_TANH = -1;
        }
        if ((comboOptions & 8) != 0) {
            this.d_tsquaredFld.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_TSQUARED);
            this.IX_TSQUARED = comboIndex++;
            this.d_panel.add(this.d_tsquaredFld, gbc);
        } else {
            this.IX_TSQUARED = -1;
        }
        if ((comboOptions & 0x10) != 0) {
            this.d_button.setVisible(comboIndex == 0);
            this.d_combo.addItem((String)STR_CUSTOM);
            this.IX_FROM_TABLE = comboIndex++;
            this.d_panel.add((Component)this.d_button, gbc);
        } else {
            this.IX_FROM_TABLE = -1;
        }
        this.d_combo.setMinimumSize(this.d_combo.getPreferredSize());
        this.loadFunction(TimeFunction.newDefault());
    }

    public void addToPanel(guiPanel panel, int beginCol, int beginRow, int top, int left, int bottom, int right) {
        GridBagUtil.add(panel, this.getLabel(), beginCol + 0, beginRow, 1, 1, top, left, bottom, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getCombo(), beginCol + 1, beginRow, 1, 1, top, 0, bottom, 6, 2, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.getEditor(), beginCol + 2, beginRow, 1, 1, top, 0, bottom, right, 2, 0.0, 0.0, 17);
    }

    public void setEnabled(boolean enable) {
        for (Component comp : this.getComponents()) {
            comp.setEnabled(enable);
        }
    }

    public boolean isEnabled() {
        for (Component comp : this.getComponents()) {
            if (!comp.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public void setVisible(boolean isVisible) {
        if (isVisible) {
            for (Component comp : this.getComponents()) {
                comp.setVisible(true);
            }
            this.updateComponents();
        } else {
            for (Component comp : this.getComponents()) {
                comp.setVisible(false);
            }
        }
    }

    public void updateComponents() {
        boolean def = this.d_combo.getSelectedIndex() == this.IX_DEFAULT;
        boolean auto = this.d_combo.getSelectedIndex() == this.IX_AUTO;
        boolean tanh = this.d_combo.getSelectedIndex() == this.IX_TANH;
        boolean tsquared = this.d_combo.getSelectedIndex() == this.IX_TSQUARED;
        boolean table = this.d_combo.getSelectedIndex() == this.IX_FROM_TABLE;
        this.d_defaultFld.setVisible(def);
        this.d_autoFld.setVisible(auto);
        this.d_tanhFld.setVisible(tanh);
        this.d_tsquaredFld.setVisible(tsquared);
        this.d_button.setVisible(table);
        if (this.d_tipTable != null && this.d_tipTable.containsKey(this.d_combo.getSelectedIndex())) {
            this.d_rampLab.setToolTipText((String)this.d_tipTable.get(this.d_combo.getSelectedIndex()));
        } else {
            this.d_rampLab.setToolTipText(null);
        }
        this.d_panel.revalidate();
    }

    public TimeFunction<?> saveFunction() {
        TimeFunction rateRampup = null;
        String selectedItem = this.d_combo.getSelectedItem();
        if (selectedItem == STR_CUSTOM) {
            rateRampup = new TimeFunction.Custom(this.d_rampAction.d_ramp);
        } else if (selectedItem == STR_TSQUARED) {
            rateRampup = new TimeFunction.TSquared((UnitDouble)this.d_tsquaredFld.getValue());
        } else if (selectedItem == STR_TANH) {
            rateRampup = new TimeFunction.TanH((UnitDouble)this.d_tanhFld.getValue());
        } else if (selectedItem == STR_DEFAULT) {
            rateRampup = TimeFunction.newDefault();
        }
        return rateRampup;
    }

    public void loadFunction(TimeFunction func) {
        TimeFunction defFunc = TimeFunction.newDefault();
        if (defFunc.equals(func)) {
            this.d_combo.setSelectedItem(STR_DEFAULT);
        } else if (func instanceof TimeFunction.TanH) {
            this.d_tanhFld.setValue((UnitDouble)func.val);
            this.d_combo.setSelectedItem(STR_TANH);
        } else if (func instanceof TimeFunction.TSquared) {
            this.d_tsquaredFld.setValue((UnitDouble)func.val);
            this.d_combo.setSelectedItem(STR_TSQUARED);
        } else if (func instanceof TimeFunction.Custom) {
            this.d_rampAction.d_ramp = (Ramp)func.val;
            this.d_combo.setSelectedItem(STR_CUSTOM);
        } else {
            this.d_combo.setSelectedIndex(-1);
        }
    }

    public Component[] getComponents() {
        return new Component[]{this.d_panel, this.d_combo, this.d_rampLab};
    }

    public guiLabel getLabel() {
        return this.d_rampLab;
    }

    public guiComboBox getCombo() {
        return this.d_combo;
    }

    public guiPanel getEditor() {
        return this.d_panel;
    }

    public JButton getButton() {
        return this.d_button;
    }

    public ValueField getTanhField() {
        return this.d_tanhFld;
    }

    public ValueField getTsquaredField() {
        return this.d_tsquaredFld;
    }

    public ValueField getAutoField() {
        return this.d_autoFld;
    }

    public void setToolTipLookUp(Hashtable h) {
        this.d_tipTable = h;
    }

    public boolean validateData(boolean showWarn, boolean allowModify) {
        Ramp r;
        Window parentComponent = SwingUtilities.getWindowAncestor(this.d_combo);
        String selectedItem = this.d_combo.getSelectedItem();
        if (selectedItem == STR_CUSTOM && this.d_button.isEnabled() && this.d_button.isVisible() && (r = this.d_rampAction.getRamp()).isEmpty()) {
            if (showWarn) {
                String msg = String.format(Intl.intl("Custom %s table must not be empty."), this.d_label);
                JOptionPane.showMessageDialog(parentComponent, msg, Intl.intl("Ramp Error"), 0);
            }
            if (allowModify) {
                this.d_button.requestFocus();
            }
            return false;
        }
        return true;
    }

    private class PreFireComboBox
    extends guiComboBox {
        private static final long serialVersionUID = 1111741296664998502L;

        private PreFireComboBox() {
        }

        @Override
        protected void fireActionEvent() {
            TimeFunctionEditor.this.updateComponents();
            super.fireActionEvent();
        }
    }

    public static class RampAction
    implements ActionListener {
        private Modifiable d_owner;
        private Ramp d_ramp;

        public RampAction(Modifiable owner) {
            this.d_owner = owner;
            this.d_ramp = new Ramp(Collections.EMPTY_LIST, RampInputs.TIME, 28);
        }

        public Ramp getRamp() {
            return this.d_ramp;
        }

        public void setRamp(Ramp ramp) {
            this.d_ramp = ramp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Ramp postRamp;
            RampFuncDlg rampDlg = RampFuncDlg.newTimeFracDlg(this.d_ramp);
            if (rampDlg.doModal() == 1 && !theUtil.equal(this.d_ramp, postRamp = rampDlg.getRamp())) {
                this.d_ramp = postRamp;
                this.rampEdited(true);
                return;
            }
            this.rampEdited(false);
        }

        protected void rampEdited(boolean committed) {
            if (committed) {
                this.d_owner.setModified(true);
            }
        }
    }
}

