/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.util.Util;
import thunderheadeng.gui.ADomainObject;
import thunderheadeng.gui.guiAction;

public class RenameAction<T extends INamed, MgrT extends Composite<T>>
extends guiAction {
    private static final long serialVersionUID = -3997701728956750319L;
    private final ManagerDlg<T, MgrT> d_owner;
    private MgrT d_mgr;
    private final String d_desc;
    private final boolean d_checkFilenameSafe;

    public RenameAction(ManagerDlg<T, MgrT> owner, String objDesc) {
        this(owner, objDesc, false);
    }

    public RenameAction(ManagerDlg<T, MgrT> owner, String objDesc, boolean checkFilenameSafe) {
        super(Intl.intl("Rename") + "...");
        this.d_owner = owner;
        this.d_desc = objDesc;
        this.d_checkFilenameSafe = checkFilenameSafe;
    }

    public void init(MgrT mgr) {
        this.d_mgr = mgr;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String newName;
        if (!this.d_owner.preSave()) {
            return;
        }
        PyroMod domain = (PyroMod)((ADomainObject)this.d_mgr).getDomain();
        int selIx = this.d_owner.getList().getSelectedIx();
        INamed rec = (INamed)this.d_owner.getList().getItem(selIx);
        while (true) {
            if ((newName = JOptionPane.showInputDialog(this.d_owner, Intl.intl("Name") + ": ", rec.getName())) == null) {
                return;
            }
            try {
                newName = Util.validateName(domain, rec, newName);
                if (this.d_checkFilenameSafe && !this.checkIfNameIsFilenameSafe(newName)) {
                    throw new Exception(Intl.intl("Invalid character in name."));
                }
            }
            catch (Exception exc) {
                JOptionPane.showMessageDialog(this.d_owner, exc.getLocalizedMessage(), Intl.intl("Invalid Entry"), 0);
                continue;
            }
            break;
        }
        domain.getTaskManager().exec(new SetNameTask(rec, newName), Intl.intl("Rename"));
        this.d_owner.initItem(rec);
        this.d_owner.getList().updateModelView(this.d_mgr);
    }

    private boolean checkIfNameIsFilenameSafe(String name) {
        try {
            String fn = new File(name + ".tmp").getPath();
            Paths.get(fn, new String[0]);
            return true;
        }
        catch (InvalidPathException e) {
            return false;
        }
    }
}

