/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Window;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.image.IImage;
import thunderheadeng.image.ImageManager;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class PyroGuiUtil
extends guiUtil {
    public static final Icon WARNING_ICON = UIManager.getIcon("OptionPane.warningIcon");
    public static final Icon ERROR_ICON = UIManager.getIcon("OptionPane.errorIcon");
    public static final Icon INFORMATION_ICON = UIManager.getIcon("OptionPane.informationIcon");
    public static final Icon QUESTION_ICON = UIManager.getIcon("OptionPane.questionIcon");
    public static final Icon PLAIN_ICON = UIManager.getIcon("OptionPane.plainIcon");
    public static final ImageIcon NEW = PyroGuiUtil.loadPyroSimIcon("newobj.png");
    public static final int FS_OPTIONS = 3;

    public static boolean invalidateFld(Component parent, boolean showWarn, boolean allowModify, guiField field, String msg) {
        if (showWarn) {
            guiDialog.showInvalidEntryMessage(parent, msg);
        }
        if (allowModify) {
            field.requestFocus();
        }
        return false;
    }

    public static boolean invalidateFld(Component parent, boolean showWarn, boolean allowModify, ValueField field, String msg) {
        if (showWarn) {
            guiDialog.showInvalidEntryMessage(parent, msg);
        }
        if (allowModify) {
            field.requestFocus();
        }
        return false;
    }

    public static guiLabel label(String txt, String tooltip) {
        guiLabel lbl = new guiLabel(txt);
        lbl.setToolTipText(tooltip);
        return lbl;
    }

    public static Icon createNewObjIcon(String pyroImage) {
        return new DecoratedIcon(PyroGuiUtil.loadPyroSimIcon(pyroImage), NEW, 3);
    }

    public static ImageIcon loadPyroSimIcon(String name) {
        return guiUtil.loadIcon("pyrosim/icons/" + name);
    }

    public static ImageIcon loadPyroSimIcon(String name, int maxDimension) {
        return guiUtil.loadIcon("pyrosim/icons/" + name, maxDimension);
    }

    public static boolean decorateCellRenderer(PyroMod data, Consumer<Icon[]> redecorate, Object value, JLabel c, boolean isSelected, boolean cellHasFocus) {
        try (PyroMod.Lock lock = data.beginRead();){
            if (value instanceof IPyroObject) {
                IPyroObject pyroObj = (IPyroObject)value;
                TVEntryPoint<IPyroObject> ep = TVEntryPoints.ep(pyroObj);
                c.setText(ep.getName(pyroObj));
                c.setFont(ep.getFont(data, pyroObj));
                c.setEnabled(ep.isVisible(data, pyroObj));
                Icon[] baseIcons = ep.getIcons(data, pyroObj, redecorate);
                c.setIcon(baseIcons[0]);
                c.setDisabledIcon(baseIcons[1]);
                c.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static void pack(Component c) {
        JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, c);
        if (dlg != null) {
            dlg.pack();
        }
    }

    public static IImage loadTeciImage(String path) {
        return ImageManager.getImage(path, 3, 0);
    }

    public static String format(UnitDouble ud, int type) {
        UnitSystem us = PyroSim.getApp().getUnitSystem();
        Unit unit = us.getUnit(type);
        return Global.format(ud.convert(unit));
    }

    public static Window getWindow(Component c) {
        if (c instanceof Window) {
            return (Window)c;
        }
        return SwingUtilities.getWindowAncestor(c);
    }

    public static ButtonGroup groupButtons(Collection<? extends AbstractButton> buttons) {
        ButtonGroup gp = new ButtonGroup();
        for (AbstractButton abstractButton : buttons) {
            gp.add(abstractButton);
        }
        return gp;
    }

    public static String encodeToHtmlLabel(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return "<html>" + str.replace("\n", "<br>");
    }

    public static <T> T ui(Callable<T> worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                return worker.call();
            }
            Object[] result = new Object[1];
            EventQueue.invokeAndWait(() -> {
                result[0] = PyroGuiUtil.call(worker);
            });
            return (T)result[0];
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            PyroGuiUtil.crash(e);
            return null;
        }
    }

    public static void ui(Runnable worker) throws CancellationException {
        try {
            if (EventQueue.isDispatchThread()) {
                worker.run();
            } else {
                EventQueue.invokeAndWait(worker);
            }
        }
        catch (CancellationException e) {
            throw e;
        }
        catch (Throwable e) {
            PyroGuiUtil.crash(e);
        }
    }

    private static <T> T call(Callable<T> worker) {
        try {
            return worker.call();
        }
        catch (Throwable e) {
            PyroGuiUtil.crash(e);
            return null;
        }
    }

    public static void crash(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        while (t.getCause() != null) {
            t = t.getCause();
        }
        throw new RuntimeException(t);
    }

    public static Dimension determineMinimumTabbedPaneSize(guiPanel ... panels) {
        Dimension largestDim = new Dimension(0, 0);
        for (guiPanel panel : panels) {
            Dimension prefferedPanelSize = panel.getPreferredSize();
            if (prefferedPanelSize.width > largestDim.width) {
                largestDim.width = prefferedPanelSize.width;
            }
            if (prefferedPanelSize.height <= largestDim.height) continue;
            largestDim.height = prefferedPanelSize.height;
        }
        JTabbedPane testTabs = new JTabbedPane();
        testTabs.add(null, "MMMM");
        Dimension preferredTabSize = testTabs.getPreferredSize();
        largestDim.width += preferredTabSize.width;
        largestDim.height += preferredTabSize.height;
        return largestDim;
    }
}

