/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JComponent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tasks.SelectTask;
import thunderheadeng.gui.dialogs.AFindDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.util.Task;

public class PyroFindDlg
extends AFindDlg<INamed, PyroMod> {
    private static final long serialVersionUID = 2717303226830472259L;
    private guiCheckBox d_objectNames;
    private guiCheckBox d_objectTags;

    public PyroFindDlg(Window owner, PyroMod domain) {
        super(owner, domain);
    }

    @Override
    public void perform(guiComboBox<String> findFld, guiLabel message, AFindDlg.ActionAfterQuery action) {
        this.run(findFld, message, action);
    }

    @Override
    protected Collection<JComponent> getSubclassComponents() {
        if (this.d_objectNames == null) {
            this.d_objectNames = new guiCheckBox(Intl.intl("Object Names"));
            this.d_objectNames.setToolTipText(Intl.intl("Includes the names of objects in the search."));
            this.d_objectNames.setSelected(true);
        }
        if (this.d_objectTags == null) {
            this.d_objectTags = new guiCheckBox(Intl.intl("Object Tags"));
            this.d_objectTags.setToolTipText(Intl.intl("Includes an object's tags in the search."));
            this.d_objectTags.setSelected(true);
        }
        return List.of(this.d_objectNames, this.d_objectTags);
    }

    @Override
    protected Collection<INamed> find(String query) {
        if (query.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Collection objects = ((PyroMod)this.getDomain()).getSelectableMembers().stream().filter(obj -> obj instanceof INamed).map(obj -> (INamed)obj).collect(Collectors.toList());
        Function<INamed, Stream> getSearchStrings = this.d_objectNames.isSelected() && this.d_objectTags.isSelected() ? o -> {
            Stream<String> strings = Stream.of(o.getName());
            if (o instanceof ITaggable) {
                ITaggable taggable = (ITaggable)((Object)o);
                strings = Stream.concat(strings, taggable.getTags().stream().map(NamedPyroObject::getName));
            }
            return strings;
        } : (this.d_objectNames.isSelected() ? o -> Stream.of(o.getName()) : (this.d_objectTags.isSelected() ? o -> {
            if (o instanceof ITaggable) {
                ITaggable taggable = (ITaggable)((Object)o);
                return taggable.getTags().stream().map(NamedPyroObject::getName);
            }
            return Stream.empty();
        } : o -> Stream.empty()));
        return this.performSearch(query, objects, getSearchStrings);
    }

    @Override
    protected void selectNext() {
        if (!this.getIterator().hasNext()) {
            return;
        }
        ((PyroMod)this.getDomain()).getTaskManager().exec((Task)new SelectTask((PyroMod)this.getDomain(), this.getIterator().next()), Intl.intl("Find"), 20);
    }

    @Override
    protected void selectAll() {
        ((PyroMod)this.getDomain()).getTaskManager().exec((Task)new SelectTask((PyroMod)this.getDomain(), this.getSelection()), Intl.intl("Find"), 20);
    }
}

