/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewTypeDlg<ObjT extends IPyroObject, TypeT>
extends guiDialog {
    private static final long serialVersionUID = 2559290931720333058L;
    private final Composite<ObjT> d_mgr;
    private final guiTextField d_nameFld;
    private final guiComboBox<TypeT> d_typeCB;
    private final ItemListener d_suggestNameListener;
    private final DocumentListener d_nameListener;

    public NewTypeDlg(Window owner, String title, Composite<ObjT> mgr, String typeLbl, guiComboBox<TypeT> typeCB) {
        super(owner, title, 9);
        this.d_mgr = mgr;
        this.d_nameFld = new guiTextField();
        this.d_typeCB = typeCB;
        this.d_suggestNameListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NewTypeDlg.this.suggestName();
            }
        };
        this.d_nameListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            public void changed() {
                NewTypeDlg.this.d_typeCB.removeItemListener(NewTypeDlg.this.d_suggestNameListener);
                NewTypeDlg.this.d_nameFld.getDocument().removeDocumentListener(this);
            }
        };
        this.d_nameFld.getDocument().addDocumentListener(this.d_nameListener);
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new GridBagLayout());
        guiLabel nameLbl = new guiLabel(Intl.intl("Name:"));
        guiLabel quanLbl = new guiLabel(typeLbl);
        GridBagUtil.add(panel, quanLbl, 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_typeCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, nameLbl, 0, 1, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(panel, this.d_nameFld, 1, 1, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
    }

    public Composite<ObjT> getManager() {
        return this.d_mgr;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.d_typeCB.addItemListener(this.d_suggestNameListener);
            this.suggestName();
        } else {
            this.d_typeCB.removeItemListener(this.d_suggestNameListener);
        }
        super.setVisible(visible);
    }

    protected void suggestName() {
        this.d_nameFld.getDocument().removeDocumentListener(this.d_nameListener);
        TypeT type = this.d_typeCB.getSelectedItem();
        String newName = this.getNameSuggestion((PyroMod)this.d_mgr.getDomain(), type);
        this.d_nameFld.setText(newName);
        this.d_nameFld.getDocument().addDocumentListener(this.d_nameListener);
    }

    protected String getNameSuggestion(PyroMod domain, TypeT type) {
        return type.toString();
    }

    protected void validateName(PyroMod domain, TypeT type, String name) throws Exception {
    }

    public String getSelectedName() {
        return this.d_nameFld.getText().trim();
    }

    public TypeT getSelectedType() {
        return this.d_typeCB.getSelectedItem();
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_nameFld.getText();
        if (reqName.length() < 1) {
            String msg = Intl.intl("A name must be specified.");
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        try {
            this.validateName((PyroMod)this.d_mgr.getDomain(), this.d_typeCB.getSelectedItem(), reqName);
        }
        catch (Exception e) {
            String msg = e.getLocalizedMessage();
            this.showMessageBox(msg);
            this.requestFocusHack();
            return false;
        }
        return true;
    }

    protected static class NameInUseException
    extends Exception {
        private static final long serialVersionUID = -7782920107540813641L;

        public NameInUseException() {
            super(Intl.intl("Name already in use. Each name must be unique."));
        }
    }
}

