/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.util.HashSet;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewDlg<T extends INamed>
extends guiDialog {
    private static final long serialVersionUID = 5381656238273106373L;
    private final IPyroObject d_mgr;
    private final Class<T> d_type;
    private final guiTextField d_name;
    private final String d_typeDesc;
    private Set<String> d_reservedNames;

    public NewDlg(IPyroObject mgr, Class<T> type, String typeDesc) {
        super((Window)Application.getApp().getActiveFrame(), String.format(Intl.intl("New %s"), typeDesc), 9);
        this.d_mgr = mgr;
        this.d_typeDesc = typeDesc;
        this.d_type = type;
        this.d_name = new guiTextField(this.generateUniqueName());
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(dlgPanel, new guiLabel(Intl.intl("Name") + ":"), 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(dlgPanel, this.d_name, 1, 0, 1, 1, 0, 0, 6, 0);
    }

    public void addReservedName(String name) {
        if (this.d_reservedNames == null) {
            this.d_reservedNames = new HashSet<String>();
        }
        this.d_reservedNames.add(name);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        String reqName = this.d_name.getText();
        if (this.d_name.getText().length() < 1) {
            String msg = String.format(Intl.intl("You must name the %s."), this.d_typeDesc);
            this.showMessageBox(msg);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        if (((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).isRegistered(reqName)) {
            String msg = Intl.intl("Name already in use.") + "\n" + String.format(Intl.intl("Each %s must have a unique name."), this.d_typeDesc);
            this.showMessageBox(msg);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        if (this.d_reservedNames != null && this.d_reservedNames.contains(reqName)) {
            String msg = Intl.intl("This name is reserved.  Please choose another.");
            this.showMessageBox(msg);
            this.d_name.requestFocus();
            this.d_name.selectAll();
            return false;
        }
        return true;
    }

    @Override
    public int doModal() {
        return super.doModal();
    }

    @Override
    public String getName() {
        return this.d_name.getValue();
    }

    private String generateUniqueName() {
        return ((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).generateName();
    }

    private boolean nameInUse(String name) {
        return ((PyroMod)this.d_mgr.getDomain()).getNames(this.d_type).isRegistered(name);
    }
}

