/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import javax.security.auth.login.FailedLoginException;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import pyrosim.Intl;
import pyrosim.domain.GridProcessUtil;
import pyrosim.gui.FDSRunMonitor;
import pyrosim.gui.ProcessUtil;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class MpiUtil {
    public static Optional<ProcessUtil.ProcessResult> runFds(File cwd, File runFdsExe, List<String> runFdsArgs, File mpiexecExe, List<String> mpiexecArgs, File fdsExe, List<String> fdsArgs, Map<String, String> ompEnvOpts, int timeout) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(runFdsExe.getPath());
        args.addAll(runFdsArgs);
        args.add(mpiexecExe.getName());
        args.addAll(mpiexecArgs);
        args.add(fdsExe.getName());
        args.addAll(fdsArgs);
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(cwd);
        MpiUtil.scrubEnvMpi(pb.environment());
        pb.environment().putAll(ompEnvOpts);
        pb.environment().put("PATH", MpiUtil.buildEnvPath("", fdsExe.getParentFile().getPath(), mpiexecExe.getParentFile().getPath(), System.getenv("WINDIR"), System.getenv("WINDIR") + "\\system32"));
        System.out.println("ENV:  " + String.valueOf(pb.environment()));
        System.out.println("CMD:  " + MpiUtil.buildCmdStr(pb.command()));
        System.out.println("WDIR: " + String.valueOf(pb.directory()));
        try {
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start(), timeout);
            return Optional.of(pr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static void scrubEnvMpi(Map<String, String> env) {
        env.clear();
    }

    public static String buildEnvPath(String origPath, String ... addFolders) {
        LinkedHashSet<String> noDups = new LinkedHashSet<String>(Arrays.asList(addFolders));
        StringBuilder sb = new StringBuilder();
        for (String addFolder : noDups) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(addFolder);
        }
        if (origPath == null) {
            return sb.toString();
        }
        if (!origPath.isEmpty() && !origPath.endsWith(File.pathSeparator)) {
            return origPath + File.pathSeparator + sb.toString();
        }
        return origPath + sb.toString();
    }

    public static Map<String, String> getMpiEnvEx(FDSRunMonitor.OpenMpOptions omp) {
        LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
        if (System.getProperty("I_MPI_WAIT_MODE") != null) {
            env.put("I_MPI_WAIT_MODE", System.getProperty("I_MPI_WAIT_MODE"));
        } else {
            env.put("I_MPI_WAIT_MODE", "1");
        }
        if (omp.numThreadsFlag) {
            env.put("OMP_NUM_THREADS", omp.numThreads);
        }
        if (omp.stacksizeFlag) {
            env.put("OMP_STACKSIZE", omp.stacksize);
        }
        return env;
    }

    public static int getNumOpenMPThreads(FDSRunMonitor.OpenMpOptions omp) {
        int numThreads = 1;
        if (omp.numThreadsFlag) {
            try {
                numThreads = Integer.parseInt(omp.numThreads);
            }
            catch (Exception e) {
                return numThreads;
            }
        }
        return numThreads;
    }

    public static int getNumProcs(GridProcessUtil.PROC_COUNT processAllocRule, int numEnabledMeshes) {
        if (GridProcessUtil.PROC_COUNT.ONE_PROC == processAllocRule) {
            return 1;
        }
        if (GridProcessUtil.PROC_COUNT.PER_CORE == processAllocRule) {
            int numCores = Runtime.getRuntime().availableProcessors();
            return Math.min(Math.max(1, numEnabledMeshes), numCores);
        }
        if (GridProcessUtil.PROC_COUNT.PER_MESH == processAllocRule) {
            return Math.max(1, numEnabledMeshes);
        }
        assert (false) : "Unknown process allocation parameter.";
        return 1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Integer> getNumPhysicalCores() {
        try {
            ProcessBuilder pb = new ProcessBuilder("wmic", "cpu", "get", "NumberOfCores");
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start(), 1);
            try (Scanner scan = new Scanner(pr.stdout);){
                String found = scan.findWithinHorizon("\\d+", pr.stdout.length());
                if (found == null) return Optional.empty();
                Optional<Integer> optional = Optional.of(Integer.parseInt(found));
                return optional;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Optional.empty();
    }

    public static String buildCmdStr(List<String> args) {
        StringBuilder fullCmd = new StringBuilder();
        for (String arg : args) {
            if (fullCmd.length() != 0) {
                fullCmd.append(" ");
            }
            if (arg.contains(" ")) {
                fullCmd.append("\"" + arg + "\"");
                continue;
            }
            fullCmd.append(arg);
        }
        return fullCmd.toString();
    }

    public static int testHydraServiceReady(Window parent, File mpiexec) {
        ProcessBuilder pb = new ProcessBuilder("sc", "query", "PyroSim MPI Hydra Service");
        try {
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start());
            if (pr.stdout.contains("RUNNING")) {
                return 0;
            }
            throw new Exception(pr.stderr);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(Intl.intl("Error connecting to MPI process manager (hydra service):"));
            sb.append(System.lineSeparator());
            sb.append(e.getLocalizedMessage());
            e.printStackTrace();
            return JOptionPane.showOptionDialog(parent, sb.toString(), Intl.intl("Hydra Service Warning"), 2, 2, null, new String[]{Intl.intl("Ignore"), Intl.intl("Cancel")}, Intl.intl("Ignore"));
        }
    }

    public static boolean testMpiCredentialsPresent(Window parent, File mpiexec) {
        ProcessBuilder pb = new ProcessBuilder(mpiexec.getPath(), "-validate");
        MpiUtil.scrubEnvMpi(pb.environment());
        try {
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start());
            if (pr.stderr.isEmpty() && pr.stdout.startsWith("SUCCESS")) {
                return true;
            }
            if (pr.stderr.isEmpty() && pr.stdout.startsWith("FAIL")) {
                return false;
            }
            throw new Exception(pr.stderr + System.lineSeparator() + pr.stdout);
        }
        catch (Exception e) {
            StringBuffer sb = new StringBuffer();
            sb.append(Intl.intl("Error validating stored credentials:"));
            sb.append(System.lineSeparator());
            sb.append(e.getLocalizedMessage());
            e.printStackTrace();
            JOptionPane.showMessageDialog(parent, sb.toString(), "MPIEXEC -VALIDATE", 0);
            return false;
        }
    }

    public static boolean validateMpiAuth(Window parent, File mpiexec) throws Exception {
        ProcessBuilder pb = new ProcessBuilder(mpiexec.getPath(), "hostname");
        MpiUtil.scrubEnvMpi(pb.environment());
        try {
            ProcessUtil.ProcessResult pr = ProcessUtil.run(pb.start(), 20);
            if (!pr.success) {
                StringBuffer sb = new StringBuffer();
                sb.append(Intl.intl("Error: mpiexec hostname took too long to execute"));
                sb.append(System.lineSeparator());
                sb.append(pr.stdout.trim());
                sb.append(System.lineSeparator());
                sb.append(pr.stderr.trim());
                throw new Exception(sb.toString());
            }
            if (pr.stdout.contains("Credentials") && pr.stdout.contains("rejected")) {
                throw new FailedLoginException(pr.stdout);
            }
            if (pr.stdout.contains("bind error") || pr.stderr.contains("bind error")) {
                StringBuffer sb = new StringBuffer();
                sb.append(Intl.intl("Error starting test process using stored credentials:"));
                sb.append(System.lineSeparator());
                sb.append(pr.stdout.trim());
                sb.append(System.lineSeparator());
                sb.append(pr.stderr.trim());
                sb.append(System.lineSeparator());
                sb.append(Intl.intl("This error usually indicates multiple conflicting MPI installations."));
                throw new Exception(sb.toString());
            }
            if (!pr.stdout.isEmpty()) {
                return true;
            }
            StringBuffer sb = new StringBuffer();
            sb.append(Intl.intl("Error starting test process using stored credentials:"));
            sb.append(System.lineSeparator());
            sb.append(pr.stdout.trim());
            sb.append(System.lineSeparator());
            sb.append(pr.stderr.trim());
            throw new Exception(sb.toString());
        }
        catch (FailedLoginException e) {
            e.printStackTrace();
            StringBuffer sb = new StringBuffer();
            sb.append(Intl.intl("Error starting test process using stored credentials:"));
            sb.append(System.lineSeparator());
            sb.append(e.getLocalizedMessage().trim());
            sb.append(System.lineSeparator());
            sb.append(System.lineSeparator());
            sb.append(Intl.intl("Click Cancel to re-enter credentials."));
            return 0 == JOptionPane.showOptionDialog(parent, sb.toString(), Intl.intl("MPI Authentication Test"), 2, 2, null, new String[]{Intl.intl("Ignore"), Intl.intl("Cancel")}, Intl.intl("Ignore"));
        }
    }

    public static boolean mpiAuth(Window parent, File mpiexec) {
        try {
            String uname;
            if (MpiUtil.testMpiCredentialsPresent(parent, mpiexec) && MpiUtil.validateMpiAuth(parent, mpiexec)) {
                return true;
            }
            List<String> listing = MpiUtil.listInput(mpiexec, MpiUtil.getMPIArgs(mpiexec, "-whoami"));
            String name = listing.isEmpty() ? "" : listing.get(listing.size() - 1);
            int sep = name.indexOf(92);
            if (0 <= sep) {
                String domain = name.substring(0, sep);
                uname = name.substring(sep + 1);
                name = String.format("%s\\%s", domain.toUpperCase(), uname);
            }
            while (true) {
                PasswordDlg dlg;
                if ((dlg = new PasswordDlg(parent, name)).doModal() != 1) {
                    return false;
                }
                uname = dlg.getUser();
                if (uname.isEmpty()) {
                    MpiUtil.authError(parent, Intl.intl("MPI requires a user name."));
                    continue;
                }
                char[] pw = dlg.getPassword();
                if (pw.length == 0) {
                    MpiUtil.authError(parent, Intl.intl("MPI requires a non-blank password."));
                    continue;
                }
                String[] args = MpiUtil.getMPIArgs(mpiexec, "-register");
                Process p = Runtime.getRuntime().exec(args, null, mpiexec.getParentFile());
                PrintWriter stdin = new PrintWriter(p.getOutputStream());
                stdin.println(uname);
                stdin.println(pw);
                stdin.println(pw);
                stdin.flush();
                Arrays.fill(pw, '0');
                MpiUtil.listInput(p);
                if (MpiUtil.validateMpiAuth(parent, mpiexec)) break;
            }
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            String msg = MpiUtil.formatException(e);
            MpiUtil.authError(parent, msg);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(parent, e.getLocalizedMessage(), Intl.intl("MPI Authentication Test"), 0);
            return false;
        }
        return false;
    }

    private static String formatException(Exception e) {
        return String.format(Intl.intl("An unknown error ocurred running mpiexec:%n%s"), e.getClass().getSimpleName() + ": " + e.getLocalizedMessage());
    }

    private static void authError(Window parent, String msg) {
        JOptionPane.showMessageDialog(parent, msg, Intl.intl("Authorization Error"), 0);
    }

    private static List<String> listInput(File mpi, String[] args) throws IOException {
        File dir = mpi.getParentFile();
        Process p = Runtime.getRuntime().exec(args, null, dir);
        return MpiUtil.listInput(p);
    }

    private static List<String> listInput(Process p) throws IOException {
        InputCatcher inCatcher = new InputCatcher(p.getInputStream());
        Thread tIn = new Thread(inCatcher);
        Thread tErr = new Thread(new InputCatcher(p.getErrorStream()));
        tIn.start();
        tErr.start();
        try {
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            tIn.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            tErr.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (inCatcher.d_caughtError != null) {
            throw inCatcher.d_caughtError;
        }
        return inCatcher.d_input;
    }

    private static String[] getMPIArgs(File mpi, String arg) {
        return new String[]{mpi.getAbsolutePath(), arg};
    }

    private static class PasswordDlg
    extends guiDialog {
        private static final long serialVersionUID = 8419347243881908319L;
        private final JPasswordField d_password;
        private final guiTextField d_user;

        public PasswordDlg(Window owner, String username) {
            super(owner, Intl.intl("Enter Password"), 9);
            MultiLineLabel header = new MultiLineLabel(Intl.intl("Please enter a password for MPI to start processes on your computer."));
            header.setColumns(30);
            guiLabel userLabel = new guiLabel(Intl.intl("Username:"));
            guiLabel passLabel = new guiLabel(Intl.intl("Password:"));
            this.d_user = new guiTextField(username);
            this.d_password = new JPasswordField();
            this.d_password.setEchoChar('*');
            guiPanel panel = this.getDialogPane();
            panel.setLayout(new GridBagLayout());
            GridBagUtil.add(panel, header, 0, 0, 2, 1, 0, 0, 12, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, userLabel, 0, 1, 1, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_user, 1, 1, 1, 1, 0, 0, 12, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(panel, passLabel, 0, 2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(panel, this.d_password, 1, 2, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    d_user.requestFocusInWindow();
                }
            });
        }

        public char[] getPassword() {
            return this.d_password.getPassword();
        }

        public String getUser() {
            return this.d_user.getValue();
        }
    }

    private static class InputCatcher
    implements Runnable {
        private final List<String> d_input;
        private final InputStream d_stream;
        private IOException d_caughtError = null;

        public InputCatcher(InputStream is) {
            this.d_stream = is;
            this.d_input = new ArrayList<String>();
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.d_stream));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    this.d_input.add(line);
                }
            }
            catch (IOException e) {
                this.d_caughtError = e;
            }
        }
    }
}

