/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import pyrosim.domain.IPyroObject;
import pyrosim.io.fds.DefaultFieldRenderer;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.IFDSFieldRenderer;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.theUtil;

public class FDSRecordPreviewPanel
extends guiPanel {
    private static final long serialVersionUID = -5113367942772205385L;
    private FDSRenderer d_render;
    private FDSRenderProps d_renderProps;
    private String d_oldText;
    private JTextPane d_textPane;
    private Map<String, List<FDSRenderRecord>> d_prevRecs = null;
    public boolean d_renderDeps;
    private Predicate<FDSRenderRecord> d_recordFilter;

    public FDSRecordPreviewPanel(FDSRenderer render) {
        this(render, Filters.acceptAll());
    }

    public FDSRecordPreviewPanel(FDSRenderer render, Predicate<FDSRenderRecord> recordFilter) {
        super(new BorderLayout());
        this.d_recordFilter = recordFilter;
        this.d_render = render;
        this.d_renderProps = this.d_render.getProps();
        this.d_textPane = new JTextPane();
        this.d_textPane.setEditable(false);
        this.d_textPane.setFont(this.d_textPane.getFont().deriveFont(10.5f));
        JScrollPane jsp = new JScrollPane(this.d_textPane);
        this.d_oldText = "";
        this.d_renderDeps = false;
        jsp.setBorder(BorderFactory.createEtchedBorder());
        jsp.setPreferredSize(new Dimension(10, 70));
        this.add((Component)jsp, "Center");
    }

    public void setRecordFilter(Predicate<FDSRenderRecord> filter) {
        this.d_recordFilter = filter;
    }

    public void setRenderDeps(boolean flag) {
        this.d_renderDeps = flag;
    }

    public void setRecord(IPyroObject obj, boolean showDiff) {
        List objs = obj == null ? Collections.emptyList() : Arrays.asList(obj);
        this.setRecord(objs, showDiff, "");
    }

    public void setRecord(Collection<? extends IPyroObject> objs, boolean showDiff, String tailNote) {
        StyledDocument textDoc = (StyledDocument)this.d_textPane.getEditorKit().createDefaultDocument();
        Style diffStyle = textDoc.addStyle("diff_style", null);
        StyleConstants.setBackground(diffStyle, new Color(240, 216, 168));
        Style tailNoteStyle = textDoc.addStyle("tailnote_style", null);
        StyleConstants.setItalic(tailNoteStyle, true);
        if (objs != null) {
            PrintWriter writer = new PrintWriter(new DocWriter(textDoc));
            FDSRecordCollector recCollector = new FDSRecordCollector(this.d_renderProps);
            this.d_render.renderObjects(recCollector, objs, Collections.emptyMap());
            List newRecs = this.d_renderDeps ? recCollector.getRecords().stream().filter(this.d_recordFilter).collect(Collectors.toList()) : recCollector.getRecordMap().entrySet().stream().filter(kvPair -> objs.contains(kvPair.getKey()) || kvPair.getKey() == null).map(Map.Entry::getValue).flatMap(list -> list.stream()).filter(this.d_recordFilter).collect(Collectors.toList());
            HashMap<String, List<FDSRenderRecord>> newRecMap = new HashMap<String, List<FDSRenderRecord>>();
            for (Iterator rec : newRecs) {
                List recs = newRecMap.computeIfAbsent(((FDSRecord)((Object)rec)).getType(), t -> new ArrayList());
                recs.add(rec);
            }
            LinkedIdentityHashMap<FDSRenderRecord, IFDSFieldRenderer> renderers = new LinkedIdentityHashMap<FDSRenderRecord, IFDSFieldRenderer>();
            if (showDiff && this.d_prevRecs != null) {
                for (Map.Entry newEntry : newRecMap.entrySet()) {
                    List<FDSRenderRecord> oldTypeRecs;
                    if (((List)newEntry.getValue()).size() != 1 || (oldTypeRecs = this.d_prevRecs.get(newEntry.getKey())) == null || oldTypeRecs.size() != 1) continue;
                    FDSRenderRecord newRec = (FDSRenderRecord)((List)newEntry.getValue()).get(0);
                    FDSRenderRecord oldRec = oldTypeRecs.get(0);
                    FDSRecord.DiffResult diffResult = oldRec.diff(newRec);
                    HashSet<String> changes = new HashSet<String>(diffResult.additional);
                    changes.addAll(diffResult.different);
                    renderers.put(newRec, new FieldRenderer(textDoc, changes));
                }
            }
            this.d_prevRecs = newRecMap;
            for (FDSRenderRecord rec : newRecs) {
                this.d_renderProps.pushProps();
                this.d_renderProps.setRenderMultiLine(false);
                rec.renderRecord(writer, this.d_renderProps, renderers.getOrDefault(rec, DefaultFieldRenderer.INSTANCE));
                this.d_renderProps.popProps();
            }
            try {
                textDoc.insertString(textDoc.getLength(), tailNote, tailNoteStyle);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            try {
                String newText = textDoc.getText(0, textDoc.getLength());
                if (newText.equals(this.d_oldText)) {
                    return;
                }
                this.d_oldText = newText;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.d_textPane.setDocument(textDoc);
            for (FieldRenderer frenderer : theUtil.filter(renderers.values(), FieldRenderer.class)) {
                for (int[] diffs : frenderer.d_changeIxes.values()) {
                    if (diffs == null) continue;
                    this.d_textPane.setCaretPosition(diffs[0]);
                    this.d_textPane.moveCaretPosition(diffs[1]);
                    this.d_textPane.setCharacterAttributes(diffStyle, true);
                }
            }
            this.d_textPane.setCaretPosition(0);
        } else {
            this.d_textPane.setDocument(textDoc);
        }
    }

    private static class DocWriter
    extends Writer {
        private final Document d_doc;

        public DocWriter(Document doc) {
            this.d_doc = doc;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            try {
                this.d_doc.insertString(this.d_doc.getLength(), new String(cbuf, off, len), null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    private static class FieldRenderer
    implements IFDSFieldRenderer {
        private final Document d_doc;
        private Map<String, int[]> d_changeIxes;

        public FieldRenderer(Document doc, Set<String> changesToLookFor) {
            this.d_doc = doc;
            this.d_changeIxes = new HashMap<String, int[]>(changesToLookFor.size());
            for (String str : changesToLookFor) {
                this.d_changeIxes.put(str, null);
            }
        }

        @Override
        public void render(PrintWriter writer, String key, String renderString) {
            int begin = this.d_doc.getLength();
            writer.append(renderString);
            int end = this.d_doc.getLength();
            if (this.d_changeIxes.containsKey(key)) {
                this.d_changeIxes.put(key, new int[]{begin, end});
            }
        }
    }
}

