/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javafx.stage.FileChooser;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class FDSLibraryDlg
extends ALibraryDlg<IPyroObject> {
    private static final long serialVersionUID = 6394989489998116704L;
    private static final Map<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>> s_retrievers = new HashMap<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>>();
    private final PyroMod d_domain;
    private final guiComboBox<IMgrRetriever<? extends IPyroObject>> d_libCB;
    private PyroMod d_libModel = null;
    private final String d_predefinedLibInstallPath;
    private final String d_predefinedLibAppDataPath;
    private static final String d_libExt = "fds";

    private static <T extends IPyroObject> void registerRetriever(IMgrRetriever<T> retriever) {
        s_retrievers.put(retriever.getType(), retriever);
    }

    public FDSLibraryDlg(JFrame owner, PyroSim app, Class<? extends IPyroObject> defLibType) {
        super(owner, app, Intl.intl("PyroSim Libraries"), d_libExt);
        this.d_domain = app.getMediator();
        this.d_predefinedLibInstallPath = new File(app.getInstallDir()).getPath();
        this.d_predefinedLibAppDataPath = new File(app.getAppDataDir()).getPath();
        WindowListener[] listeners = this.getWindowListeners();
        for (int m = 0; m < listeners.length; ++m) {
            this.removeWindowListener(listeners[m]);
        }
        this.addWindowListener(new CloseListener());
        this.d_libCB = new guiComboBox();
        this.d_libCB.setRenderer(new RetrieverRenderer());
        this.d_libCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FDSLibraryDlg.this.updateLibSelection();
            }
        });
        guiPanel mainPanel = this.getDialogPane();
        GridBagUtil.add(mainPanel, new guiLabel(Intl.intl("Category:")), 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_libCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, new JSeparator(0), 0, 1, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        this.init(PyroPrefs.PREF_LASTLIBRARY, PyroPrefs.LastFDSDatabaseDirProp, IPyroObject.class);
        Collection<IMgrRetriever<? extends IPyroObject>> retrievers = theUtil.sort(new ANameSorter<IMgrRetriever<? extends IPyroObject>>(this){

            @Override
            protected String getName(IMgrRetriever<? extends IPyroObject> o) {
                return o.getDescription();
            }
        }, s_retrievers.values());
        this.d_libCB.setItems(retrievers);
        if (defLibType != null) {
            this.d_libCB.setSelectedItem(s_retrievers.get(defLibType));
        } else {
            this.d_libCB.setSelectedIndex(0);
        }
        this.updateLibSelection();
    }

    private void updateLibSelection() {
        this.loadList(FDSLibraryDlg.getObjects(this.d_domain, this.d_libCB.getSelectedItem()), this.d_modelObjs, IPyroObject.class);
        this.loadList(FDSLibraryDlg.getObjects(this.d_libModel, this.d_libCB.getSelectedItem()), this.d_libObjs, IPyroObject.class);
    }

    private Composite getManager(PyroMod model) {
        return this.d_libCB.getSelectedItem().getManager(model);
    }

    @Override
    protected List<IPyroObject> deserialize(String filename, boolean showWarnings) {
        File file = new File(filename);
        try {
            this.d_libModel = new PyroMod();
            FDSParser parser = FDS.newParser(6);
            FDSParseResult result = parser.parseFile(file.getAbsolutePath(), this.d_libModel);
            if (showWarnings) {
                result.warningReport.showWarnings(this.getParent(), false);
            }
            this.d_libUnsaved = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
        return this.getLibModel();
    }

    @Override
    protected File serialize(List<IPyroObject> objects) {
        ArrayList<? extends IPyroObject> toExport = new ArrayList<IPyroObject>();
        for (IMgrRetriever<? extends IPyroObject> retriever : s_retrievers.values()) {
            toExport.addAll(FDSLibraryDlg.getObjects(this.d_libModel, retriever));
        }
        return Actions.exportToFile(this, new File(String.format("%s.%s", FilenameManager.splitFilename(this.d_currentLib)[0], d_libExt)), this.d_libModel, toExport, PyroPrefs.LastFDSDatabaseDirProp.key.toString());
    }

    @Override
    protected void loadFromLibrary() {
        this.d_app.beginWaitCursor();
        this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_libModel, this.d_domain);
        this.d_app.endWaitCursor();
    }

    @Override
    protected void saveToLibrary() {
        this.d_app.beginWaitCursor();
        boolean changed = this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_domain, this.d_libModel);
        if (changed) {
            this.d_libUnsaved = true;
        }
        this.d_app.endWaitCursor();
    }

    @Override
    protected void deleteModObjs() {
        this.deleteObjs(this.d_modelObjs, this.d_domain);
    }

    @Override
    protected void deleteLibObjs() {
        if (!this.deleteObjs(this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
    }

    private List<IPyroObject> deleteObjs(JList<IPyroObject> jlist, PyroMod domain) {
        List<IPyroObject> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return objs;
        }
        Task t = Actions.getDeleteTask(domain, objs);
        if (t == null) {
            return objs;
        }
        domain.getTaskManager().exec(t, Intl.intl("Delete Objects"));
        this.loadList(FDSLibraryDlg.getObjects(domain, this.d_libCB.getSelectedItem()), jlist, IPyroObject.class);
        this.preserveSelection(objs, jlist, this.getManager(domain));
        return objs;
    }

    private void preserveSelection(Collection<? extends IPyroObject> lastSelectedObjs, JList<IPyroObject> jlist, Composite<? extends IPyroObject> mgr) {
        ArrayList<Integer> selIxes = new ArrayList<Integer>();
        jlist.clearSelection();
        for (IPyroObject iPyroObject : lastSelectedObjs) {
            if (!mgr.containsDeep(iPyroObject)) continue;
            selIxes.add(this.indexOf(jlist, iPyroObject));
        }
        jlist.setSelectedIndices(theUtil.toIntArray(selIxes));
    }

    private int indexOf(JList<IPyroObject> jlist, IPyroObject obj) {
        for (int m = 0; m < jlist.getModel().getSize(); ++m) {
            if (jlist.getModel().getElementAt(m) != obj) continue;
            return m;
        }
        return -1;
    }

    private static <T extends IPyroObject> Collection<T> getObjects(PyroMod domain, IMgrRetriever<T> retriever) {
        Composite<T> mgr = retriever.getManager(domain);
        Predicate<T> filter = retriever.getFilter();
        Collection<T> objs = filter != null ? mgr.flatten(retriever.getType(), filter) : ((APyroObject)mgr).flatten(retriever.getType());
        return Util.sort(objs);
    }

    private Set<? extends IPyroObject> getListContents(JList<IPyroObject> list) {
        LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
        ListModel<IPyroObject> model = list.getModel();
        for (int m = 0; m < model.getSize(); ++m) {
            objs.add(model.getElementAt(m));
        }
        return objs;
    }

    public boolean copyListSelection(JList<IPyroObject> jlistBeingCopied, JList<IPyroObject> jlistCopiedTo, PyroMod containerBeingCopied, PyroMod containerCopiedTo) {
        Set<? extends IPyroObject> oldListVals = this.getListContents(jlistCopiedTo);
        List<IPyroObject> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return true;
        }
        try {
            Actions.doTransfer(containerBeingCopied, containerCopiedTo, objsToCopy);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.loadList(FDSLibraryDlg.getObjects(containerCopiedTo, this.d_libCB.getSelectedItem()), jlistCopiedTo, IPyroObject.class);
        Set<? extends IPyroObject> newListVals = this.getListContents(jlistCopiedTo);
        newListVals.removeAll(oldListVals);
        this.preserveSelection(newListVals, jlistCopiedTo, this.getManager(containerCopiedTo));
        return true;
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IPyroObject obj = (IPyroObject)value;
        r.setText(Util.getName(obj));
    }

    @Override
    protected List<IPyroObject> getLibModel() {
        ArrayList<IPyroObject> objs = new ArrayList<IPyroObject>();
        if (this.d_libCB.getSelectedItem() != null) {
            objs.addAll(FDSLibraryDlg.getObjects(this.d_libModel, this.d_libCB.getSelectedItem()));
        }
        return objs;
    }

    @Override
    protected void resetLibModel() {
        this.d_libModel = new PyroMod();
    }

    @Override
    protected PyroMod getDomain() {
        return this.d_domain;
    }

    @Override
    protected FileChooser.ExtensionFilter[] getFileFilter() {
        return new FileChooser.ExtensionFilter[]{FileFilters.EXT_FILTER_FDS6_DATABASE};
    }

    @Override
    protected String getPredefinedPath() {
        return this.d_predefinedLibInstallPath;
    }

    @Override
    protected String getAppDataPath() {
        return this.d_predefinedLibAppDataPath;
    }

    static {
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Materials"), Material.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getMaterialMgr();
            }
        });
        Predicate<Surface> surfFilter = new Predicate<Surface>(){

            @Override
            public boolean test(Surface o) {
                return !o.isPredefined();
            }
        };
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Surfaces"), Surface.class, (Predicate)surfFilter){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSurfaceMgr();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Gas-phase Reactions"), Reaction.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getReactions();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Smoke Detector Models"), SmokeLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSmokeLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Heat Detector Models"), HeatLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getHeatLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Sprinkler Link Models"), SprinklerLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprinklerLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Spray Models"), SprayModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprayModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Particles"), Particle.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getPartList();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Species"), ExSpec.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getExSpecList();
            }
        });
    }

    public static interface IMgrRetriever<T extends IPyroObject> {
        public String getDescription();

        public Composite<T> getManager(PyroMod var1);

        public Class<T> getType();

        public Predicate<T> getFilter();
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FDSLibraryDlg.this.d_status = 8;
        }
    }

    private class RetrieverRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4364493595770278351L;

        private RetrieverRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            IMgrRetriever obj = (IMgrRetriever)value;
            this.setText(obj.getDescription());
            return this;
        }
    }

    public static abstract class AMgrRetriever<T extends IPyroObject>
    implements IMgrRetriever<T> {
        private final Class<T> d_type;
        private final String d_desc;
        private final Predicate<T> d_filter;

        public AMgrRetriever(String desc, Class<T> type) {
            this(desc, type, null);
        }

        public AMgrRetriever(String desc, Class<T> type, Predicate<T> filter) {
            this.d_desc = desc;
            this.d_filter = filter;
            this.d_type = type;
        }

        @Override
        public String getDescription() {
            return this.d_desc;
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public Predicate<T> getFilter() {
            return this.d_filter;
        }
    }
}

