/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JFrame;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.gui.actions.CloudFDSUtil;
import thunderheadeng.gui.HTMLLabel;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiProgressMonitor;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.TaskProgress;

public class CloudFDSDlg
extends guiDialog {
    static final long serialVersionUID = 1L;
    static final Object LATEST = FDS_VERS.FDS_6_10_1;
    private static final Collection<Integer> s_cpuOpts = Collections.unmodifiableList(Arrays.asList(1, 2, 4, 8, 16, 32, 48, 64, 96, 112, 180, 224));
    private static final Collection<String> s_memOpts = Collections.unmodifiableList(Arrays.asList("highcpu", "standard", "highmem", "hypercpu", "highcore", "hypercore"));
    private final guiComboBox<CloudFDSUtil.CLOUD_PROVIDERS> d_cloudServCombo = new guiComboBox<CloudFDSUtil.CLOUD_PROVIDERS>(CloudFDSUtil.CLOUD_PROVIDERS.CFD_FEA);
    private final guiTextField d_apiKeyField = new guiTextField();
    private final guiComboBox<FDS_VERS> d_fdsVerCombo;
    private final guiComboBox<String> d_ramCombo;
    private final guiComboBox<Integer> d_cpuCombo;

    public CloudFDSDlg(JFrame owner) {
        this(owner, false);
    }

    public CloudFDSDlg(JFrame owner, boolean credsOnly) {
        super((Window)owner, Intl.intl("Cloud FDS Parameters"), 9);
        this.d_apiKeyField.setToolTipText(Intl.intl("Enter the API Key from your CFD FEA Service Account Profile"));
        this.d_fdsVerCombo = new guiComboBox<FDS_VERS>(FDS_VERS.values());
        this.d_ramCombo = new guiComboBox<String>(s_memOpts);
        this.d_cpuCombo = new guiComboBox<Integer>(s_cpuOpts);
        guiPanel panel = this.getDialogPane();
        panel.setLayout(new MigLayout("insets 0", "[][50][50]"));
        String serviceMsg = Intl.intl("Create a new CFD FEA Service Account");
        HTMLLabel serviceLink = new HTMLLabel("<a href=https://cloudhpc.cloud/cloud-hpc-registration-thunderheadeng/>" + serviceMsg + "</a>", 200);
        String docMsg = Intl.intl("Read about provisioning options");
        HTMLLabel docLink = new HTMLLabel("<a href=https://cfdfeaservice.it/wiki/cloud-hpc/#!simulation.md>" + docMsg + "</a>", 200);
        panel.add(new guiLabel(Intl.intl("Cloud Provider:")));
        panel.add(this.d_cloudServCombo, "growx, wrap");
        panel.add(new guiLabel(Intl.intl("API Key:")));
        panel.add((Component)this.d_apiKeyField, "wrap, growx, span 2");
        panel.add((Component)serviceLink, "gapbottom 2, wrap, skip 1, spanx 2");
        if (!credsOnly) {
            panel.add(new guiLabel(Intl.intl("FDS Version:")));
            panel.add(this.d_fdsVerCombo, "growx, wrap");
            panel.add(new guiLabel(Intl.intl("Number of vCPUs:")));
            panel.add(this.d_cpuCombo, "growx, wrap");
            panel.add(new guiLabel(Intl.intl("Memory Options:")));
            panel.add(this.d_ramCombo, "growx, wrap");
            panel.add((Component)docLink, "gapbottom 2, wrap, skip 1, spanx 2");
        }
        this.init();
    }

    private void init() {
        this.d_fdsVerCombo.setSelectedItem(LATEST);
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        this.d_apiKeyField.setValue(apiKey);
        if (!apiKey.isEmpty()) {
            try {
                TaskProgress progress = new TaskProgress();
                String msg = Intl.intl("Retrieving Options...");
                guiProgressMonitor monitor = new guiProgressMonitor(this, msg, true, progress, 0);
                new Thread(() -> {
                    progress.setMessage(msg);
                    CloudFDSUtil.SimOptions options = CloudFDSUtil.getSimOptions();
                    if (!options.cpuOptions.isEmpty()) {
                        this.d_cpuCombo.setItems(options.cpuOptions);
                    }
                    if (!options.memoryOptions.isEmpty()) {
                        this.d_ramCombo.setItems(options.memoryOptions);
                    }
                    progress.cancel();
                }).start();
                monitor.begin();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (this.d_apiKeyField.getText().trim().isEmpty()) {
            return this.invalidateFld(showWarn, allowModify, this.d_apiKeyField, Intl.intl("Please enter an API Key."));
        }
        return true;
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            PyroSim.setPref(PyroPrefs.FDSFEA_ApiKey, this.d_apiKeyField.getValue(), false);
        }
        return result;
    }

    public CloudFDSUtil.CLOUD_PROVIDERS getProvider() {
        return this.d_cloudServCombo.getSelectedItem();
    }

    public FDS_VERS getFDSVers() {
        return this.d_fdsVerCombo.getSelectedItem();
    }

    public String getRamOpts() {
        return this.d_ramCombo.getSelectedItem();
    }

    public int getNumCores() {
        return this.d_cpuCombo.getSelectedItem();
    }

    public String getAPIKey() {
        return this.d_apiKeyField.getValue();
    }

    public CFD_FEA_Params getParams() {
        return new CFD_FEA_Params(this.getAPIKey(), this.getFDSVers(), this.getRamOpts(), this.getNumCores());
    }

    public static enum FDS_VERS {
        FDS_6_7_0("fds6.7.0", "FDS 6.7.0"),
        FDS_6_7_1("fds6.7.1", "FDS 6.7.1"),
        FDS_6_7_4("fds6.7.4", "FDS 6.7.4"),
        FDS_6_7_5("fds6.7.5", "FDS 6.7.5"),
        FDS_6_7_6("fds6.7.6", "FDS 6.7.6"),
        FDS_6_7_7("fds6.7.7", "FDS 6.7.7"),
        FDS_6_7_8("fds6.7.8", "FDS 6.7.8"),
        FDS_6_7_9("fds6.7.9", "FDS 6.7.9"),
        FDS_6_8_0("fds6.8.0", "FDS 6.8.0"),
        FDS_6_9_0("fds6.9.0", "FDS 6.9.0"),
        FDS_6_9_1("fds6.9.1", "FDS 6.9.1"),
        FDS_6_10_0("fds6.10.0", "FDS 6.10.0"),
        FDS_6_10_1("fds6.10.1", "FDS 6.10.1");

        public final String value;
        public final String name;

        private FDS_VERS(String value, String name) {
            this.value = value;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class CFD_FEA_Params {
        public final FDS_VERS version;
        public final String ramOpt;
        public final int numCores;
        public final String uri;
        public final String apiKey;

        public CFD_FEA_Params(String apiKey, FDS_VERS vers, String ram, int cores) {
            this.apiKey = apiKey;
            this.version = vers;
            this.ramOpt = ram;
            this.numCores = cores;
            this.uri = CloudFDSUtil.CLOUD_PROVIDERS.CFD_FEA.URI;
        }
    }
}

