/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.geom;

import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Converter;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.PoolOptimizer;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class Geometry
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final Unit LU = SI.METER;
    public static final Unit AU = SI.RADIAN;
    public static final UnitPoint3D UP3D_ZERO = new UnitPoint3D(0.0, 0.0, 0.0, SI.METER);
    public static final double TRIANGULATE_TOL = 0.1;
    public static final double CURVE_TOL = 0.01;
    public static final IPointOptimizer P3D_POOL = new PoolOptimizer();

    public static UnitPoint3D xform(Matrix4d xform, UnitPoint3D p) {
        Point3d p3d = p.getPoint3dValue(LU);
        xform.transform(p3d);
        Converter converter = LU.getConverterTo(p.getUnit());
        return new UnitPoint3D(converter.convert(p3d.x), converter.convert(p3d.y), converter.convert(p3d.z), p.getUnit());
    }

    public static IGeomNode finalize(IGeomNode geom, boolean optimize) {
        if (!optimize) {
            return geom;
        }
        return geom.modify(g -> g.optimize(P3D_POOL), e -> e);
    }

    public static enum Axis {
        X,
        Y,
        Z;


        public UnitDouble getVal(Point3d p) {
            return new UnitDouble(switch (this.ordinal()) {
                case 0 -> p.x;
                case 1 -> p.y;
                default -> p.z;
            }, LU);
        }

        public Vector3d toVec() {
            switch (this.ordinal()) {
                case 0: {
                    return GeomConstants.VEC3D_XPOS;
                }
                case 1: {
                    return GeomConstants.VEC3D_YPOS;
                }
            }
            return GeomConstants.VEC3D_ZPOS;
        }
    }
}

