/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.zones;

import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.bridge.BridgeList;
import pyrosim.domain.zones.Leak;
import pyrosim.domain.zones.Zone;

public class LeakUtil {
    public static Collection<Leak> getLeaks(PyroMod domain, Zone zone) {
        return LeakUtil.getLeaks(domain.getBridges(), zone);
    }

    public static Collection<Leak> getLeaks(BridgeList bridges, Zone zone) {
        return bridges.flatten(Leak.class, new ZoneFilter(zone));
    }

    public static Leak getLeak(PyroMod domain, Zone zone1, Zone zone2) {
        ZoneFilter zone1Filter = new ZoneFilter(zone1);
        Predicate<Leak> filter = zone1Filter.and(new ZoneFilter(zone2));
        Collection<Leak> leaks = domain.getBridges().flatten(Leak.class, filter);
        return leaks.isEmpty() ? null : leaks.iterator().next();
    }

    public static class ZoneFilter
    implements Predicate<Leak> {
        public final Zone zone;

        public ZoneFilter(Zone zone) {
            this.zone = zone;
        }

        @Override
        public boolean test(Leak o) {
            return o.zone1 == this.zone || o.zone2 == this.zone;
        }
    }
}

