/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.zones;

import java.io.Serializable;
import java.util.Collection;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.bridge.ABridgeObj;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.domain.zones.Zone;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;

public class Leak
extends ABridgeObj
implements Serializable {
    static final long serialVersionUID = 1L;
    public final Zone zone1;
    public final Zone zone2;
    public final UnitDouble area;

    public Leak(Zone zone1, Zone zone2, UnitDouble area) {
        this.zone1 = zone1;
        this.zone2 = zone2;
        this.area = area;
    }

    public Zone otherZone(Zone zone) {
        return zone == this.zone1 ? this.zone2 : this.zone1;
    }

    public boolean containsZone(Zone z) {
        return this.zone1 == z || this.zone2 == z;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Leak)) {
            return false;
        }
        Leak leak = (Leak)obj;
        return (this.zone1 == leak.zone1 && this.zone2 == leak.zone2 || this.zone1 == leak.zone2 && this.zone2 == leak.zone1) && this.area.equals(leak.area);
    }

    public int hashCode() {
        return 232753806 + this.zone1.hashCode() + this.zone2.hashCode() + this.area.hashCode();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    @Override
    public void getBridgedObjects(Collection<IPyroObject> objs) {
        objs.add(this.zone1);
        objs.add(this.zone2);
    }

    public String toString() {
        return String.format("Leak[zone1=\"%s\",zone2=\"%s\",area=%s]", this.zone1.getName(), this.zone2.getName(), this.area.toString());
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, IPyroObject replacement) {
        final Zone oldZone1 = this.zone1;
        final Zone oldZone2 = this.zone2;
        return new AReplaceRefTask<Zone>((Object)old, (Object)replacement){

            @Override
            protected void set(Zone setZone) {
                if (oldZone1 == old) {
                    try {
                        Util.assignFinalField(Leak.this, "zone1", setZone);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (oldZone2 == old) {
                    try {
                        Util.assignFinalField(Leak.this, "zone2", setZone);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }
}

