/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.view;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.view.AViewGeomProp;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class SectionBox
extends AViewGeomProp<IGeom>
implements INamed,
ITaggable {
    static final long serialVersionUID = 1L;
    private Color d_color;
    private Set<Tag> d_tags;

    public SectionBox(IGeom geom) {
        super(geom);
        assert (geom.getNumPrims(1) <= 6);
        this.d_color = Color.GREEN;
        this.d_tags = Collections.emptySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_color == null) {
            this.d_color = Color.GREEN;
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setColor(Color color) {
        this.d_color = color;
        this.changedEvt(new Object[0]);
    }

    @Override
    public String getName() {
        return Intl.intl("Section Box");
    }

    @Override
    public void setName(String id) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IPrimProps.Edge eprops = new IPrimProps.Edge(this.d_color, 2.0, 61680, 0);
        ArrayList<Point3d> verts = new ArrayList<Point3d>();
        ArrayList<Integer> ixes = new ArrayList<Integer>();
        for (Pair<ICurve, Integer> edge : GeomUtil.getFaceOutlines((IGeom)this.get())) {
            Mesh segments = ((ICurve)edge.v1).getSegments(props.getCurveError());
            int offset = verts.size();
            verts.addAll(Arrays.asList(segments.vertices));
            for (int i : segments.indices) {
                ixes.add(i + offset);
            }
        }
        Mesh result = new Mesh(theUtil.toArray(verts, Point3d.class), theUtil.toIntArray(ixes), 1);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(result), (IPrimProps)eprops);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        this.set(geom);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getBoxGeom());
    }

    public IGeom getBoxGeom() {
        return (IGeom)this.get();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this == obj;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }
}

