/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.variant;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.domain.ramp.Ramp;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class Variant
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    public static final Variant DEFAULT = new Variant(DefObj.INSTANCE);
    public final Object val;

    private Variant(Object val) {
        this.val = val;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Variant)) {
            return false;
        }
        Variant var = (Variant)obj;
        return theUtil.equal(this.val, var.val);
    }

    public int hashCode() {
        return 2508582 + theUtil.hashCode(this.val.hashCode());
    }

    private Object readResolve() throws ObjectStreamException {
        return this.val == null ? DEFAULT : this;
    }

    public Variant clone() {
        if (this.val instanceof Ramp) {
            return new Variant(((Ramp)this.val).clone());
        }
        if (this.val instanceof FractionalRamp) {
            FractionalRamp oldVal = (FractionalRamp)this.val;
            return new Variant(new FractionalRamp(oldVal.constInput, (Ramp)oldVal.fractionalRamp.clone()));
        }
        return this;
    }

    public boolean isConstant() {
        return this.val instanceof UnitDouble;
    }

    public boolean isRamp() {
        return this.val instanceof Ramp;
    }

    public boolean isFractionalRamp() {
        return this.val instanceof FractionalRamp;
    }

    public boolean isDefault() {
        return this.val == DefObj.INSTANCE;
    }

    public Type getType() {
        if (this.isConstant()) {
            return Type.CONSTANT;
        }
        if (this.isRamp()) {
            return Type.RAMP;
        }
        if (this.isFractionalRamp()) {
            return Type.FRACTIONAL_RAMP;
        }
        return Type.DEFAULT;
    }

    public static Variant constOrDefault(UnitDouble val) {
        if (val == null) {
            return Variant.def();
        }
        return Variant.constant(val);
    }

    public static Variant constant(UnitDouble val) {
        return new Variant(val);
    }

    public static Variant constant(double val, Unit unit) {
        return Variant.constant(new UnitDouble(val, unit));
    }

    public static Variant ramp(Ramp ramp) {
        return new Variant(ramp);
    }

    public static Variant def() {
        return DEFAULT;
    }

    public static Variant fracRamp(double val, Unit unit, Ramp ramp) {
        return Variant.fracRamp(new UnitDouble(val, unit), ramp);
    }

    public static Variant fracRamp(UnitDouble constVal, Ramp ramp) {
        return new Variant(new FractionalRamp(constVal, ramp));
    }

    public static class FractionalRamp
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final UnitDouble constInput;
        public final Ramp fractionalRamp;

        private FractionalRamp(UnitDouble constInput, Ramp fractionalRamp) {
            this.constInput = constInput;
            this.fractionalRamp = fractionalRamp;
        }
    }

    private static class DefObj
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final DefObj INSTANCE = new DefObj();

        private DefObj() {
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    public static enum Type {
        DEFAULT,
        CONSTANT,
        RAMP,
        FRACTIONAL_RAMP;

    }
}

