/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import pyrosim.domain.view.View;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Nullable;

public class ViewPropTask<T>
extends AUndoableTask {
    private final List<View> d_views;
    private final IPropertySet.Prop<T> d_prop;
    private final BiFunction<View, Integer, Optional<Nullable<T>>> d_newVals;
    private List<Nullable<T>> d_oldVals;

    public static <T> ViewPropTask<T> set(List<View> views, IPropertySet.Prop<T> prop, BiFunction<View, Integer, T> newVals) {
        return new ViewPropTask<T>(views, prop, (v, i) -> Optional.of(Nullable.of(newVals.apply((View)v, (Integer)i))));
    }

    public static <T> ViewPropTask<T> remove(List<View> views, IPropertySet.Prop<T> prop) {
        return new ViewPropTask<T>(views, prop, (v, i) -> Optional.empty());
    }

    public ViewPropTask(List<View> views, IPropertySet.Prop<T> prop, BiFunction<View, Integer, Optional<Nullable<T>>> newVals) {
        this.d_views = views;
        this.d_prop = prop;
        this.d_newVals = newVals;
        this.d_oldVals = null;
    }

    @Override
    public void run() {
        if (this.d_oldVals == null) {
            this.d_oldVals = new ArrayList<Nullable<T>>(this.d_views.size());
            for (View view : this.d_views) {
                boolean defined = view.isDefined(this.d_prop);
                Nullable<T> oldVal = defined ? Nullable.of(view.get(this.d_prop)) : null;
                this.d_oldVals.add(oldVal);
            }
        }
        for (int m = 0; m < this.d_views.size(); ++m) {
            View view;
            view = this.d_views.get(m);
            Optional<Nullable<T>> newVal = this.d_newVals.apply(view, m);
            if (newVal.isPresent()) {
                view.set(this.d_prop, newVal.get().val);
                continue;
            }
            view.remove(this.d_prop);
        }
    }

    @Override
    public void undo() {
        for (int m = this.d_views.size() - 1; m >= 0; --m) {
            View view = this.d_views.get(m);
            Nullable<T> oldVal = this.d_oldVals.get(m);
            if (oldVal == null) {
                view.remove(this.d_prop);
                continue;
            }
            view.set(this.d_prop, oldVal.val);
        }
    }
}

