/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroGeomSrc;
import thunderheadeng.util.Task;

public class ShowSomeGeomTask
implements Task {
    private final PyroMod d_mediator;
    private boolean[] d_oldVisible;
    private final boolean d_newVisible;
    private final List<? extends IPyroGeomSrc> d_selectedObjs;

    public ShowSomeGeomTask(PyroMod med, Collection<? extends IPyroGeomSrc> selected, boolean newVisible) {
        this.d_mediator = med;
        this.d_newVisible = newVisible;
        this.d_selectedObjs = new ArrayList<IPyroGeomSrc>(selected);
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        int index = 0;
        for (IPyroGeomSrc iPyroGeomSrc : this.d_selectedObjs) {
            iPyroGeomSrc.setVisible(this.d_oldVisible[index++]);
        }
        this.d_oldVisible = null;
        this.d_mediator.resumeUpdates();
    }

    @Override
    public int getEst() {
        return 0;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        this.d_oldVisible = new boolean[this.d_selectedObjs.size()];
        int index = 0;
        for (IPyroGeomSrc iPyroGeomSrc : this.d_selectedObjs) {
            this.d_oldVisible[index++] = iPyroGeomSrc.isVisible();
            iPyroGeomSrc.setVisible(this.d_newVisible);
        }
        this.d_mediator.resumeUpdates();
    }
}

