/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectReferencingObjTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_selObjs;

    public SelectReferencingObjTask(PyroMod med, Collection<? extends IPyroObject> objs) {
        this.d_mediator = med;
        this.d_selObjs = new ArrayList<IPyroObject>(objs);
    }

    @Override
    public int getEst() {
        return 1;
    }

    @Override
    public boolean isMajor() {
        return false;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        DepSnapshot ds = this.d_mediator.getDependencies(this.d_selObjs);
        Predicate<Object> filter = new Predicate<Object>(){

            @Override
            public boolean test(Object o) {
                if (!(o instanceof IPyroObject)) {
                    return false;
                }
                TVEntryPoint<Object> ep = TVEntryPoints.ep(o);
                if (ep == null) {
                    return false;
                }
                return ep.showInTree(SelectReferencingObjTask.this.d_mediator, o);
            }
        };
        LinkedIdentityHashSet total = new LinkedIdentityHashSet();
        for (IPyroObject iPyroObject : this.d_selObjs) {
            ds.findAllDependents(filter, iPyroObject, total);
        }
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(total);
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(this.d_selObjs);
        this.d_mediator.resumeUpdates();
    }
}

