/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.geom.AFDSObject;
import thunderheadeng.util.ATask;
import thunderheadeng.util.LinkedIdentityHashSet;

public class SelectByColorTask
extends ATask {
    private final PyroMod d_mediator;
    private final Collection<? extends AFDSObject> d_selObjs;

    public SelectByColorTask(PyroMod med, Collection<? extends AFDSObject> objs) {
        super(true);
        this.d_mediator = med;
        this.d_selObjs = new ArrayList<AFDSObject>(objs);
    }

    @Override
    public boolean isMajor() {
        return false;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        LinkedIdentityHashSet toSelect = new LinkedIdentityHashSet();
        HashSet selColors = new HashSet();
        for (AFDSObject aFDSObject : this.d_selObjs) {
            Collections.addAll(selColors, aFDSObject.getColors());
        }
        Collection<AFDSObject> objs = ((APyroObject)this.d_mediator.getObstructions()).flatten(AFDSObject.class);
        block1: for (AFDSObject obj : objs) {
            for (Color c : obj.getColors()) {
                if (!selColors.contains(c)) continue;
                toSelect.add(obj);
                continue block1;
            }
        }
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(toSelect);
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(this.d_selObjs);
        this.d_mediator.resumeUpdates();
    }
}

