/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.IModelObj;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.util.AUndoableTask;

public class SelectByBIMTypeTask
extends AUndoableTask {
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_selObjs;

    public SelectByBIMTypeTask(PyroMod pyMod, Collection<? extends IPyroObject> objs) {
        this.d_mediator = pyMod;
        this.d_selObjs = Collections.unmodifiableCollection(objs);
    }

    @Override
    public boolean isMajor() {
        return false;
    }

    @Override
    public void run() {
        this.d_mediator.pauseUpdates();
        Set initModelObjs = this.d_selObjs.stream().filter(o -> o instanceof IModelObj).map(o -> (IModelObj)o).collect(Collectors.toSet());
        Set typesToSelect = initModelObjs.stream().filter(obj -> !obj.getBIMType().equals((Object)BIMType.UNKNOWN)).map(obj -> obj.getBIMType()).collect(Collectors.toSet());
        HashSet toSelect = new HashSet();
        toSelect.addAll(this.d_mediator.getObstructions().flatten().stream().filter(obj -> typesToSelect.contains((Object)obj.getBIMType())).collect(Collectors.toSet()));
        toSelect.addAll(initModelObjs);
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(toSelect);
        this.d_mediator.resumeUpdates();
    }

    @Override
    public void undo() {
        this.d_mediator.pauseUpdates();
        this.d_mediator.getSelectionModel().clearSelection();
        this.d_mediator.getSelectionModel().selectAll(this.d_selObjs);
        this.d_mediator.resumeUpdates();
    }
}

