/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.units.UnitDouble;

public class MirrorTask
extends TransformTask {
    private final ITransform d_xform;

    public MirrorTask(PyroMod mediator, Collection<? extends IPyroObject> objects, int n, UnitDouble xPlane, UnitDouble yPlane, UnitDouble zPlane) {
        super(mediator, objects, n);
        ITransform xform = TransformUtil.IDENTITY;
        if (zPlane != null) {
            xform = xform.concatenate(TransformUtil.mirror(new Plane3d(0.0, 0.0, 1.0, -zPlane.getValue(Geometry.LU))));
        }
        if (yPlane != null) {
            xform = xform.concatenate(TransformUtil.mirror(new Plane3d(0.0, 1.0, 0.0, -yPlane.getValue(Geometry.LU))));
        }
        if (xPlane != null) {
            xform = xform.concatenate(TransformUtil.mirror(new Plane3d(1.0, 0.0, 0.0, -xPlane.getValue(Geometry.LU))));
        }
        this.d_xform = xform;
    }

    @Override
    public ITransform getXFormForIteration(int i) {
        return this.d_xform;
    }
}

