/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;

public class DeletePreserveTask
extends AUndoableTask {
    private final List<MoveRecord> d_src;

    public DeletePreserveTask(IPyroObject ... objs) {
        this(Arrays.asList(objs));
    }

    public DeletePreserveTask(Collection<? extends IPyroObject> objs) {
        this.d_src = new ArrayList<MoveRecord>(objs.size());
        for (IPyroObject iPyroObject : objs) {
            this.d_src.add(new MoveRecord(iPyroObject));
        }
    }

    protected List<MoveRecord> getRecords() {
        return this.d_src;
    }

    @Override
    public void undo() {
        LinkedIdentityHashMap<IPyroObject, ArrayList<MoveRecord>> parentMap = new LinkedIdentityHashMap<IPyroObject, ArrayList<MoveRecord>>();
        for (int m = this.d_src.size() - 1; m >= 0; --m) {
            MoveRecord rec = this.d_src.get(m);
            ArrayList<MoveRecord> oldParentObjs = (ArrayList<MoveRecord>)parentMap.get(rec.oldParent);
            if (oldParentObjs == null) {
                oldParentObjs = new ArrayList<MoveRecord>();
                parentMap.put(rec.oldParent, oldParentObjs);
            }
            oldParentObjs.add(rec);
        }
        for (Map.Entry entry : parentMap.entrySet()) {
            IPyroObject group = (IPyroObject)entry.getKey();
            List moveRecs = (List)entry.getValue();
            Collections.sort(moveRecs);
            ArrayList<IPyroObject> newList = new ArrayList<IPyroObject>(group.getMembers().size() + moveRecs.size());
            ArrayList<IPyroObject> newObjs = new ArrayList<IPyroObject>(moveRecs.size());
            Iterator<? extends IPyroObject> memberIt = group.getMembers().iterator();
            int ix = 0;
            for (MoveRecord rec : moveRecs) {
                while (ix < rec.oldPos) {
                    newList.add(memberIt.next());
                    ++ix;
                }
                newList.add(rec.moveObj);
                newObjs.add(rec.moveObj);
                ++ix;
            }
            while (memberIt.hasNext()) {
                newList.add(memberIt.next());
            }
            TVEntryPoint<IPyroObject> ep = TVEntryPoints.ep(group);
            ep.addAll(group, newObjs);
            ep.reorder(group, newList);
        }
    }

    @Override
    public void run() {
        this.recordPositions();
        for (MoveRecord pair : this.d_src) {
            TVEntryPoints.ep(pair.oldParent).remove(pair.oldParent, pair.moveObj);
        }
    }

    protected void recordPositions() {
        if (this.d_src.isEmpty() || this.d_src.get((int)0).oldParent != null) {
            return;
        }
        LinkedIdentityHashMap<IPyroObject, Integer> usedParents = new LinkedIdentityHashMap<IPyroObject, Integer>();
        IdentityHashMap<IPyroObject, MoveRecord> moveObjs = new IdentityHashMap<IPyroObject, MoveRecord>();
        for (int m = 0; m < this.d_src.size(); ++m) {
            MoveRecord mr = this.d_src.get(m);
            mr.oldParent = mr.moveObj.getParent();
            Integer count = (Integer)usedParents.get(mr.oldParent);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            usedParents.put(mr.oldParent, count);
            moveObjs.put(mr.moveObj, mr);
        }
        for (Map.Entry entry : usedParents.entrySet()) {
            int count = 0;
            int ix = 0;
            Iterator<? extends IPyroObject> it = ((IPyroObject)entry.getKey()).getMembers().iterator();
            while (it.hasNext() && count < (Integer)entry.getValue()) {
                IPyroObject member = it.next();
                MoveRecord mr = (MoveRecord)moveObjs.get(member);
                if (mr != null) {
                    mr.oldPos = ix;
                    ++count;
                }
                ++ix;
            }
        }
    }

    protected static class MoveRecord
    implements Comparable<MoveRecord> {
        public final IPyroObject moveObj;
        public IPyroObject oldParent;
        public int oldPos;

        public MoveRecord(IPyroObject moveObj) {
            this.moveObj = moveObj;
            this.oldParent = null;
            this.oldPos = -1;
        }

        @Override
        public int compareTo(MoveRecord o) {
            return this.oldPos - o.oldPos;
        }
    }
}

