/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.INamed;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.theUtil;

public class AutoRenameTask<V extends INamed>
extends AUndoableTask {
    private final PyroMod d_targetDomain;
    private final INamed[] d_objects;
    private String[] d_names;

    public AutoRenameTask(PyroMod targetDomain, V ... objs) {
        this(targetDomain, (Collection<V>)Arrays.asList(objs));
    }

    public AutoRenameTask(PyroMod targetDomain, Collection<? extends V> objs) {
        this.d_targetDomain = targetDomain;
        this.d_objects = objs.toArray(new INamed[objs.size()]);
    }

    @Override
    public void undo() {
        this.rename();
    }

    @Override
    public void run() {
        if (this.d_names == null) {
            List<String> names = this.d_targetDomain.getNames().generateValidNames(Arrays.asList(this.d_objects), false);
            this.d_names = theUtil.toArray(names, String.class);
        }
        this.rename();
    }

    private void rename() {
        this.d_targetDomain.pauseUpdates();
        for (int m = 0; m < this.d_objects.length; ++m) {
            String oldName = this.d_objects[m].getName();
            String newName = this.d_names[m];
            this.d_names[m] = oldName;
            this.d_objects[m].setName(newName);
        }
        this.d_targetDomain.resumeUpdates();
    }
}

