/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.view.View;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.AUndoableTask;

public class AddTask<V extends IPyroObject>
extends AUndoableTask {
    private final Object d_objs;
    private final IPyroObject d_parent;
    private View d_prevActiveView;

    public AddTask(IPyroObject parent, V ... objs) {
        this(parent, (Collection<V>)Arrays.asList(objs));
    }

    public AddTask(IPyroObject parent, Collection<? extends V> objs) {
        this.d_parent = parent;
        this.d_objs = objs.size() == 1 ? objs.iterator().next() : new ArrayList<V>(objs);
    }

    public List<? extends V> getObjects() {
        return this.d_objs instanceof ArrayList ? (ArrayList)this.d_objs : Arrays.asList((IPyroObject)this.d_objs);
    }

    protected PyroMod getDomain() {
        return (PyroMod)this.d_parent.getDomain();
    }

    protected IPyroObject getParent() {
        return this.d_parent;
    }

    protected void pauseUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.pauseUpdates();
        }
    }

    protected void resumeUpdates() {
        PyroMod domain = this.getDomain();
        if (domain != null) {
            domain.resumeUpdates();
        }
    }

    @Override
    public void undo() {
        this.pauseUpdates();
        List<V> objs = this.getObjects();
        for (int m = objs.size() - 1; m >= 0; --m) {
            this.remove(this.d_parent, (IPyroObject)objs.get(m));
        }
        if (this.d_prevActiveView != null) {
            this.getDomain().getViews().setActiveView(this.d_prevActiveView);
        }
        this.resumeUpdates();
    }

    @Override
    public void run() {
        this.pauseUpdates();
        if (this.d_prevActiveView == null && this.getDomain() != null && !Hierarchy.flatten(this.getObjects(), View.class).isEmpty()) {
            this.d_prevActiveView = this.getDomain().getViews().getActiveView();
        }
        for (IPyroObject obj : this.getObjects()) {
            this.add(this.d_parent, obj);
        }
        this.resumeUpdates();
    }

    protected void remove(IPyroObject parent, V obj) {
        TVEntryPoints.ep(this.d_parent).remove(this.d_parent, obj);
    }

    protected void add(IPyroObject parent, V obj) {
        boolean added = TVEntryPoints.ep(this.d_parent).add(this.d_parent, obj);
        assert (added);
    }
}

