/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.tags.Tag;
import pyrosim.util.Util;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;

public interface ITaggable
extends IDirectDependent {
    public Set<Tag> getTags();

    public void setTags(Set<Tag> var1);

    public static void addTagsToDepSnapshot(ITaggable taggable, DepList deps) {
        deps.add(DLink.WEAK, taggable.getTags());
    }

    public static Task taskReplaceTagDep(IPyroObject old, final IPyroObject replacement, final ITaggable dependent) {
        if (old instanceof Tag) {
            final Tag oldTag = (Tag)old;
            return new AUndoableTask(){
                private Set<Tag> oldTags = null;

                @Override
                public void undo() {
                    if (this.oldTags != null) {
                        dependent.setTags(this.oldTags);
                        this.oldTags = null;
                    }
                }

                @Override
                public void run() {
                    if (dependent.getTags().contains(oldTag)) {
                        this.oldTags = dependent.getTags();
                        if (replacement != null) {
                            ArrayList<Tag> tagsList = new ArrayList<Tag>(this.oldTags);
                            int replacementIx = tagsList.indexOf(oldTag);
                            tagsList.set(replacementIx, (Tag)replacement);
                            dependent.setTags(new LinkedIdentityHashSet<Tag>((Collection<Tag>)tagsList));
                        } else {
                            LinkedIdentityHashSet<Tag> newTags = new LinkedIdentityHashSet<Tag>((Collection<Tag>)this.oldTags);
                            newTags.remove(oldTag);
                            dependent.setTags(newTags);
                        }
                    }
                }
            };
        }
        return EmptyTask.INSTANCE;
    }

    public static <T extends IPyroObject> void removeInvalidTagReplacements(T old, Set<T> objs) {
        if (old instanceof Tag) {
            Util.keepIfNullOr(objs, Tag.class);
        }
    }

    public static Task getTagUpdateDep() {
        return EmptyTask.INSTANCE;
    }
}

