/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.signals;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jscience.physics.units.Unit;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.util.Util;
import thunderheadeng.util.AUndoableTask;

public class SignalsUtil {
    public static Set<IPyroObject> getManualControlIgnoreRecs(ISignalSink sink) {
        DepSnapshot dp = new DepSnapshot();
        dp.takeSnapshot(sink);
        Set<IPyroObject> depends = dp.getAllDependedOn();
        Set branchesToPrune = depends.stream().filter(pyro -> pyro instanceof ControlBridge).map(pyro -> (ControlBridge)pyro).collect(Collectors.toSet());
        HashSet<IPyroObject> removeQueue = new HashSet<IPyroObject>();
        removeQueue.addAll(branchesToPrune);
        for (ControlBridge bridge : branchesToPrune) {
            DepSnapshot localBranch = new DepSnapshot();
            localBranch.takeSnapshot(bridge);
            removeQueue.addAll(localBranch.getAllDependedOn());
        }
        return removeQueue;
    }

    public static IOutPin getPin(ISignalSource src, String pinName) {
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!iOutPin.getName().equals(pinName)) continue;
            return iOutPin;
        }
        return null;
    }

    public static boolean areCompatible(Unit u1, Unit u2) {
        if (!u1.isCompatible(u2)) {
            return false;
        }
        try {
            return u1.getConverterTo(u2) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Collection<IInPin> getInputPins(Iterator<? extends ISignalSink> objs) {
        ArrayList<IInPin> pins = new ArrayList<IInPin>();
        while (objs.hasNext()) {
            pins.add(objs.next().getInputPin());
        }
        return pins;
    }

    public static boolean isCycle(ISignalSink initialNode) {
        return SignalsUtil.containsCycleImpl(initialNode, new ISignalSink[0]);
    }

    public static boolean containsCycle(ISignalSink target, ISignalSink ctrl) {
        return SignalsUtil.containsCycleImpl(ctrl, target);
    }

    private static boolean containsCycleImpl(ISignalSink start, ISignalSink ... extraStops) {
        return SignalsUtil.containsCycleImpl(start, new HashSet<ISignalSink>(Arrays.asList(extraStops)), new HashSet<ISignalSink>(Arrays.asList(extraStops)));
    }

    private static boolean containsCycleImpl(ISignalSink start, Collection<ISignalSink> extraStops, Collection<ISignalSink> neverOkay) {
        ArrayDeque<ISignalSink> open = new ArrayDeque<ISignalSink>();
        HashSet<ISignalSink> visited = new HashSet<ISignalSink>(extraStops);
        open.push(start);
        while (!open.isEmpty()) {
            ISignalSink current = (ISignalSink)open.pop();
            if (neverOkay.contains(current) && visited.contains(current)) {
                return true;
            }
            if (visited.contains(current)) {
                HashSet<ISignalSink> updatedNever = new HashSet<ISignalSink>(neverOkay);
                updatedNever.add(current);
                boolean isTrueCycle = SignalsUtil.containsCycleImpl(current, new HashSet<ISignalSink>(), updatedNever);
                if (!isTrueCycle) continue;
                return true;
            }
            visited.add(current);
            IInPin inPin = current.getInputPin();
            for (ISignalSource connSrc : inPin.getConnectedSources()) {
                if (!(connSrc instanceof ISignalSink)) continue;
                open.push((ISignalSink)((Object)connSrc));
            }
        }
        return false;
    }

    public static <T extends IPyroObject> void filterIncompatibleBridges(T old, Set<T> replacementObjs, List<IOutPin> oldConnections) {
        if (!(old instanceof ControlBridge)) {
            return;
        }
        ControlBridge oldBridge = (ControlBridge)old;
        boolean logicConnected = false;
        for (IOutPin oldOut : oldConnections) {
            if (!(oldOut instanceof ILogicOutPin)) continue;
            logicConnected = true;
        }
        if (oldBridge.isActivation()) {
            Util.keepIfNullOr(replacementObjs, cb -> ((ControlBridge)cb).isActivation());
        } else if (oldBridge.isDetector() && logicConnected) {
            Util.keepIfNullOr(replacementObjs, cb -> ((ControlBridge)cb).isDetector());
        } else if (oldBridge.isMathControl()) {
            Util.keepIfNullOr(replacementObjs, cb -> ((ControlBridge)cb).isMathControl());
        }
    }

    public static void restoreInPin(IPyroObject targetObj, IInPin targetInPin, IInPin refInPin) {
        Set<? extends IOutPin> targetConns = targetInPin.getConnections();
        Set<? extends IOutPin> refConns = refInPin.getConnections();
        ArrayList<IOutPin> toDisconnect = new ArrayList<IOutPin>(2);
        ArrayList<IOutPin> toConnect = new ArrayList<IOutPin>(2);
        for (IOutPin iOutPin : refConns) {
            if (targetConns.contains(iOutPin)) continue;
            toConnect.add(iOutPin);
        }
        for (IOutPin iOutPin : targetConns) {
            if (refConns.contains(iOutPin)) continue;
            toDisconnect.add(iOutPin);
        }
        if (toDisconnect.isEmpty() && toConnect.isEmpty()) {
            return;
        }
        toDisconnect.forEach(targetInPin::disconnect);
        toConnect.forEach(targetInPin::connect);
        targetObj.changedEvt(new Object[0]);
    }

    public static class UpdateActivationPinsTask
    extends AUndoableTask {
        private final Map<ISignalSink, ISignalSource> d_preState;
        private final Map<ISignalSink, ISignalSource> d_postState;

        public UpdateActivationPinsTask(Map<ISignalSink, ISignalSource> preState, Map<ISignalSink, ISignalSource> postState) {
            this.d_preState = preState;
            this.d_postState = postState;
        }

        private static void wireToSrc(Map<ISignalSink, ISignalSource> sinkToSrcMap) {
            for (Map.Entry<ISignalSink, ISignalSource> sinkSrcPair : sinkToSrcMap.entrySet()) {
                IInPin sinkPin = sinkSrcPair.getKey().getInputPin();
                sinkPin.disconnectAll();
                if (sinkSrcPair.getValue() != null) {
                    IOutPin srcPin = sinkSrcPair.getValue().getOutputPins().get(0);
                    sinkPin.connect(srcPin);
                }
                sinkSrcPair.getKey().changedEvt(new Object[0]);
            }
        }

        @Override
        public void undo() {
            UpdateActivationPinsTask.wireToSrc(this.d_preState);
        }

        @Override
        public void run() {
            UpdateActivationPinsTask.wireToSrc(this.d_postState);
        }
    }
}

