/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.signals;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.SignalsUtil;
import pyrosim.util.Util;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.ICloneRequired;
import thunderheadeng.util.IHasher;
import thunderheadeng.util.JavaHasher;
import thunderheadeng.util.ListSet;
import thunderheadeng.util.Task;

public abstract class AInPin
implements IInPin,
ICloneRequired,
Serializable {
    static final long serialVersionUID = 1L;
    @SkipDep
    private ISignalSink d_attachedSink;

    public AInPin(ISignalSink sink) {
        this.d_attachedSink = sink;
    }

    @Override
    public Object clone() {
        try {
            AInPin clone = (AInPin)super.clone();
            clone.d_attachedSink = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    @Override
    public AInPin clone(ISignalSink newSink) {
        AInPin pin = (AInPin)this.clone();
        pin.d_attachedSink = newSink;
        return pin;
    }

    @Override
    public void setSink(ISignalSink sink) {
        this.d_attachedSink = sink;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AInPin)) {
            return false;
        }
        AInPin pin = (AInPin)obj;
        Set<? extends IOutPin> pins1 = this.getConnections();
        Set<? extends IOutPin> pins2 = pin.getConnections();
        if (pins1.size() > 1) {
            pins1 = new ListSet<IOutPin>((IHasher<? extends IOutPin>)JavaHasher.INSTANCE, (Collection<? extends IOutPin>)pins1);
        }
        if (pins2.size() > 1) {
            pins2 = new ListSet<IOutPin>((IHasher<? extends IOutPin>)JavaHasher.INSTANCE, (Collection<? extends IOutPin>)pins2);
        }
        return pins1.equals(pins2);
    }

    public int hashCode() {
        int hash = 215294;
        for (IOutPin iOutPin : this.getConnections()) {
            hash += iOutPin.hashCode();
        }
        return hash;
    }

    @Override
    public Set<ISignalSource> getConnectedSources() {
        LinkedHashSet<ISignalSource> sources = new LinkedHashSet<ISignalSource>();
        for (IOutPin iOutPin : this.getConnections()) {
            sources.add(iOutPin.getAttachedSource());
        }
        return sources;
    }

    @Override
    public ISignalSink getAttachedSink() {
        return this.d_attachedSink;
    }

    @Override
    public boolean canConnect(IOutPin pin2) {
        return pin2.getAttachedSource() != this.getAttachedSink() && this.isCompatible(pin2);
    }

    @Override
    public void connect(IOutPin pin2) {
    }

    @Override
    public boolean disconnect(IOutPin pin2) {
        return true;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        for (IOutPin iOutPin : this.getConnections()) {
            deps.add(DLink.WEAK, (IPyroObject)iOutPin.getAttachedSource());
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        Util.keepIfNullOr(objs, ISignalSource.class);
        List<IOutPin> connectedPins = this.getConnectedPins((ISignalSource)old);
        SignalsUtil.filterIncompatibleBridges(old, objs, connectedPins);
        Iterator<T> objit = objs.iterator();
        block0: while (objit.hasNext()) {
            ISignalSource source = (ISignalSource)objit.next();
            if (source == null) continue;
            for (IOutPin connectedPin : connectedPins) {
                IOutPin pin = this.getMatchedOutPin(source, connectedPin);
                if (pin == null) {
                    objit.remove();
                    continue block0;
                }
                if (!(source instanceof ISignalSink) || !SignalsUtil.containsCycle(this.getAttachedSink(), (ISignalSink)((Object)source))) continue;
                objit.remove();
                continue block0;
            }
        }
    }

    private List<IOutPin> getConnectedPins(ISignalSource connectedSrc) {
        Set<? extends IOutPin> connections = this.getConnections();
        ArrayList<IOutPin> connectedPins = new ArrayList<IOutPin>(connections.size());
        for (IOutPin iOutPin : connections) {
            if (iOutPin.getAttachedSource() != connectedSrc) continue;
            connectedPins.add(iOutPin);
        }
        return connectedPins;
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return new ReplaceSignalSourceDepTask(this, (ISignalSource)old, (ISignalSource)replacement);
    }

    public IOutPin getMatchedOutPin(ISignalSource source, IOutPin pin) {
        IOutPin result = SignalsUtil.getPin(source, pin.getName());
        return result == null || this.isCompatible(result) ? result : null;
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    public static class ReplaceSignalSourceDepTask
    extends AUndoableTask {
        private final AInPin d_inputPin;
        private List<IOutPin> d_disconnectedPins;
        private List<IOutPin> d_connectedPins;
        private final ISignalSource d_oldSourceObj;
        private final ISignalSource d_newSourceObj;

        public ReplaceSignalSourceDepTask(AInPin inputPin, ISignalSource old, ISignalSource replacement) {
            this.d_inputPin = inputPin;
            this.d_oldSourceObj = old;
            this.d_newSourceObj = replacement;
        }

        @Override
        public void undo() {
            if (this.d_connectedPins != null) {
                for (IOutPin outPin : this.d_connectedPins) {
                    this.d_inputPin.disconnect(outPin);
                }
            }
            for (IOutPin outPin : this.d_disconnectedPins) {
                this.d_inputPin.connect(outPin);
            }
        }

        @Override
        public void run() {
            this.d_disconnectedPins = this.d_inputPin.getConnectedPins(this.d_oldSourceObj);
            for (IOutPin disconnectPin : this.d_disconnectedPins) {
                this.d_inputPin.disconnect(disconnectPin);
            }
            if (this.d_newSourceObj != null) {
                this.d_connectedPins = new ArrayList<IOutPin>(this.d_disconnectedPins.size());
                for (IOutPin disconnectPin : this.d_disconnectedPins) {
                    IOutPin newPin = this.d_inputPin.getMatchedOutPin(this.d_newSourceObj, disconnectPin);
                    assert (newPin != null);
                    if (this.d_inputPin.getConnections().contains(newPin)) continue;
                    this.d_inputPin.connect(newPin);
                    this.d_connectedPins.add(newPin);
                }
            } else {
                this.d_connectedPins = null;
            }
        }
    }
}

