/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pyrosim.Intl;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.scenario.Scenario;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiPlaceholderTextField;
import thunderheadeng.gui.guiUtil;

public class EditScenariosEditor
implements IEditor<Scenario> {
    private static final CharsetEncoder ASCII_ENC = StandardCharsets.US_ASCII.newEncoder();
    private final guiPanel d_rootPanel = new guiPanel(new GridBagLayout());
    private final JTextArea d_descriptionArea = new JTextArea(5, 0);
    private final Icon d_idInfoIcon;
    private final guiLabel d_scenarioNameLabel;
    private final guiPlaceholderTextField d_scenarioName;
    private final JTextArea d_objsArea;

    public EditScenariosEditor() {
        this.d_descriptionArea.setLineWrap(true);
        this.d_descriptionArea.setWrapStyleWord(true);
        this.d_descriptionArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changed(e);
            }

            private void changed(DocumentEvent e) {
                EditScenariosEditor.this.d_rootPanel.setModified(true);
            }
        });
        this.d_scenarioNameLabel = new guiLabel(Intl.intl("Scenario ID:"));
        this.d_scenarioName = new guiPlaceholderTextField();
        this.d_scenarioName.setEditable(false);
        Icon infoIco = UIManager.getIcon("OptionPane.informationIcon");
        Image infoIcoImg = guiUtil.convertIconToImage(infoIco);
        BufferedImage infoIcoBuffImg = guiUtil.convertImageToBufferedImage(infoIcoImg);
        double targetHt = (double)this.d_scenarioNameLabel.getPreferredSize().height * 0.7;
        double scale = targetHt / (double)infoIcoBuffImg.getHeight();
        this.d_idInfoIcon = new ImageIcon(infoIcoBuffImg.getScaledInstance((int)(scale * (double)infoIcoBuffImg.getWidth()), (int)(scale * (double)infoIcoBuffImg.getHeight()), 4));
        this.d_objsArea = new JTextArea(5, 0);
        this.d_objsArea.setEditable(false);
        GridBagHelper gbh = new GridBagHelper(this.d_rootPanel);
        gbh.addRow(this.d_scenarioNameLabel, this.d_scenarioName, 100.0, 2);
        gbh.addFilledRow(new TitleSeparator(Intl.intl("Description:")));
        gbh.addFilledRow(new JScrollPane(this.d_descriptionArea));
        gbh.addFilledRow(new TitleSeparator(Intl.intl("Disabled Objects")));
        gbh.addFilledRow(new JScrollPane(this.d_objsArea));
        gbh.addFilledRow(Box.createHorizontalStrut(300));
        gbh.finalizeRows();
    }

    private void updateNameInfo() {
        String scenarioName = this.d_scenarioName.getValue();
        Icon ico = null;
        String tooltip = "";
        if (scenarioName != null && !ASCII_ENC.canEncode(scenarioName)) {
            ico = this.d_idInfoIcon;
            tooltip = Intl.intl("FDS IDs are restricted to US ASCII characters.\nA numeric CHID will be used for FDS compatibility.");
        }
        this.d_scenarioName.setIconNote(ico);
        this.d_scenarioName.setToolTipText(tooltip);
    }

    @Override
    public void init(Scenario dataObj) {
        this.d_scenarioName.setValue(dataObj.getName());
        this.updateNameInfo();
        this.d_descriptionArea.setText(dataObj.getDescription());
        this.d_descriptionArea.setCaretPosition(0);
        List<String> paths = this.getScenarioObjectPaths(dataObj);
        this.d_objsArea.setText(String.join((CharSequence)"\n", paths));
        this.d_objsArea.setCaretPosition(0);
        this.getEditorPanel().setModified(false);
    }

    private List<String> getScenarioObjectPaths(Scenario dataObj) {
        ArrayList<String> paths = new ArrayList<String>();
        for (IPyroObject obj : dataObj.getDisabledObjs()) {
            StringBuffer sb = new StringBuffer();
            IPyroObject[] path = Hierarchy.getPath(obj);
            for (int i = 1; i < path.length; ++i) {
                TVEntryPoint<IPyroObject> ep;
                String name;
                IPyroObject pathObj = path[i];
                if (i > 1) {
                    sb.append("/");
                }
                if ((name = (ep = TVEntryPoints.ep(pathObj)).getDisplayName(pathObj)) != null) {
                    sb.append(name);
                    continue;
                }
                sb.append(pathObj.getClass().getName());
            }
            paths.add(sb.toString());
        }
        Collections.sort(paths);
        return paths;
    }

    @Override
    public Scenario commit(Scenario dataObj) {
        dataObj.setDescription(this.d_descriptionArea.getText());
        this.d_rootPanel.setModified(false);
        return dataObj;
    }

    @Override
    public guiPanel getEditorPanel() {
        return this.d_rootPanel;
    }

    @Override
    public boolean isModified() {
        return this.d_rootPanel.isModified();
    }

    @Override
    public void addObserver(Observer o) {
        this.d_rootPanel.addObserver(o);
    }

    @Override
    public void removeObserver(Observer o) {
        this.d_rootPanel.removeObserver(o);
    }
}

