/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.scenario;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.scenario.ActivateAction;
import pyrosim.domain.scenario.EditScenariosEditor;
import pyrosim.domain.scenario.Scenario;
import pyrosim.domain.scenario.ScenarioList;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.actions.Actions;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class EditScenariosAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;

    public EditScenariosAction() {
        this.putValue("Name", Intl.intl("Edit Scenarios..."));
        this.putValue("ShortDescription", Intl.intl("Edit Scenarios"));
        this.putValue("LongDescription", Intl.intl("Edit scenarios for this model."));
        ImageIcon icon = Actions.createIcon("pyrosim/icons/composite16_3.gif");
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim pySim = PyroSim.getApp();
        PyroMod pyMod = pySim.getMediator();
        EditScenariosAction.run(pySim.getMainFrame(), pyMod);
    }

    public static void run(JFrame owner, PyroMod pyMod) {
        ManagerDlg<Scenario, ScenarioList> mgrDlg = new ManagerDlg<Scenario, ScenarioList>(owner, Intl.intl("Edit Scenarios"), false);
        guiAction actNew = new guiAction(Intl.intl("New..."), evt -> EditScenariosAction.handleMgrNew(pyMod, mgrDlg));
        RenameAction actRename = new RenameAction(mgrDlg, Intl.intl("Scenario Object"), true);
        actRename.init(pyMod.getScenarios());
        guiAction actDelete = new guiAction(Intl.intl("Delete"), evt -> mgrDlg.deleteCurrentItem());
        guiAction actActivate = new guiAction(Intl.intl("Activate"), evt -> ActivateAction.run(pyMod, (Scenario)mgrDlg.getSelectedInList()));
        mgrDlg.setSelectionHandler(obj -> {
            boolean itemIsNull = mgrDlg.getSelectedInList() == null;
            boolean itemIsLast = pyMod.getScenarios().flatten().size() < 2;
            actNew.setEnabled(true);
            actRename.setEnabled(!itemIsNull);
            actDelete.setEnabled(!itemIsNull && !itemIsLast);
            actActivate.setEnabled(!itemIsNull);
        });
        mgrDlg.init(pyMod.getScenarios(), new EditScenariosEditor(), null, new guiAction[]{actNew, actRename, actActivate, actDelete}, pyMod.getScenarios().getActive());
        mgrDlg.doModal();
    }

    private static void handleMgrNew(PyroMod pyMod, ManagerDlg<Scenario, ScenarioList> mgrDlg) {
        if (!mgrDlg.preSave()) {
            return;
        }
        NewScenarioDlg scenarioDlg = new NewScenarioDlg(mgrDlg, Intl.intl("New Scenario"), 9, pyMod);
        if (scenarioDlg.doModal() == 1) {
            Scenario newScenario = EditScenariosAction.createNewScenario(pyMod, scenarioDlg.getSelectedScenario(), scenarioDlg.getNewName());
            mgrDlg.getList().updateModelView(pyMod.getScenarios());
            mgrDlg.getList().select(newScenario);
            ActivateAction.run(pyMod, newScenario);
        }
    }

    protected static Scenario createNewScenario(PyroMod pyMod, Scenario base, String name) {
        Scenario newScenario = new Scenario(base);
        newScenario.setName(name);
        AddTask tsk = new AddTask((IPyroObject)pyMod.getScenarios(), (IPyroObject[])new Scenario[]{newScenario});
        pyMod.getTaskManager().exec(tsk, Intl.intl("New Scenario"));
        return newScenario;
    }

    private static class NewScenarioDlg
    extends guiDialog {
        private static final long serialVersionUID = 1L;
        private PyroMod pyMod;
        private static guiTextField scenarioNameField;
        private JComboBox<Scenario> scenarioBox;

        public NewScenarioDlg(Window owner, String title, int buttons, PyroMod pyroMod) {
            super(owner, title, buttons);
            this.pyMod = pyroMod;
            guiPanel dlgPanel = this.getDialogPane();
            dlgPanel.setLayout(new GridBagLayout());
            String scenarioNameLabel = Intl.intl("Scenario Name:");
            scenarioNameField = new guiTextField();
            scenarioNameField.setText(this.pyMod.getNames(Scenario.class).generateName());
            scenarioNameField.setMinChars(1);
            scenarioNameField.setRangeCheck(true);
            scenarioNameField.addFocusListener(new FocusListener(this){

                @Override
                public void focusLost(FocusEvent e) {
                    scenarioNameField.validateData(true, false);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.scenarioBox = new JComboBox(new Vector(this.pyMod.getScenarios().getMembers(Scenario.class).stream().sorted(Comparator.comparing(NamedPyroObject::getName)).collect(Collectors.toList())));
            this.scenarioBox.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    this.setText(((Scenario)value).getName());
                    return this;
                }
            });
            GridBagHelper gbh = new GridBagHelper(dlgPanel);
            gbh.addRow(scenarioNameLabel, scenarioNameField);
            gbh.addRow(Intl.intl("Based On:"), this.scenarioBox, 1.0);
            gbh.finalizeRows();
        }

        protected String getNewName() {
            return scenarioNameField.getText();
        }

        protected Scenario getSelectedScenario() {
            return (Scenario)this.scenarioBox.getSelectedItem();
        }

        @Override
        public boolean validateData(boolean showwarn, boolean allowmodify) {
            try {
                String fn = new File(scenarioNameField.getText() + ".tmp").getPath();
                Paths.get(fn, new String[0]);
                return true;
            }
            catch (InvalidPathException e) {
                JOptionPane.showMessageDialog(this.getParent(), Intl.intl("Invalid scenario name."), Intl.intl("Invalid Entry"), 0);
                return false;
            }
        }
    }
}

