/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.reaction;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.reaction.Reaction;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.Task;

public class ReactionList
extends Composite<Reaction>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Deprecated
    private List<Reaction> d_changes;
    @Deprecated
    private boolean d_trackChanges;
    @Deprecated
    private transient List<Reaction> d_reactionsBeforePaste;
    @Deprecated
    private transient Reaction d_activeReacBeforePaste;

    public ReactionList() {
        this(Intl.intl("Reactions"));
        this.d_trackChanges = false;
        this.d_changes = null;
    }

    public ReactionList(String name) {
        super(name, Reaction.class);
    }

    public List<Reaction> getActiveReactions() {
        return this.flatten().stream().filter(r -> r.isActive()).collect(Collectors.toList());
    }

    public Task taskSetActiveReaction(final Reaction reac) {
        final List<Reaction> initialActives = this.getActiveReactions();
        final ArrayList newActives = new ArrayList();
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                if (!newActives.isEmpty()) {
                    ReactionList.this.setActiveReactionList(newActives);
                } else {
                    ReactionList.this.setActiveReaction(reac);
                    newActives.addAll(ReactionList.this.getActiveReactions());
                }
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(initialActives);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    public Task taskClearActiveReaction(final Reaction reac) {
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                reac.setActive(false);
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReaction(reac);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    public Task taskSetActiveReactions(final List<Reaction> reacs) {
        final List<Reaction> initialActives = this.getActiveReactions();
        return new AUndoableTask(){

            @Override
            public void run() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(reacs);
                ReactionList.this.resumeUpdates();
            }

            @Override
            public void undo() {
                ReactionList.this.pauseUpdates();
                ReactionList.this.setActiveReactionList(initialActives);
                ReactionList.this.resumeUpdates();
            }
        };
    }

    private void setActiveReactionList(Collection<Reaction> activateReacs) {
        this.clearActiveReactionList();
        for (Reaction r : activateReacs) {
            r.setActive(true);
        }
    }

    private void clearActiveReactionList() {
        for (Reaction r : this.flatten()) {
            r.setActive(false);
        }
    }

    public void setActiveReaction(Reaction r) {
        List<Reaction> actives = this.getActiveReactions();
        this.clearActiveReactionList();
        actives.stream().filter(activeReac -> !activeReac.getReacType().equals((Object)r.getReacType())).forEach(activeReac -> activeReac.setActive(false));
        r.setActive(true);
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getClass().getSimpleName());
        str.append(Arrays.toString(this.getMembers().toArray()));
        return str.toString();
    }

    @Override
    public boolean add(IPyroObject obj) {
        if (!(obj instanceof Reaction) && !(obj instanceof ReactionList)) {
            throw new IllegalArgumentException(obj.getClass().getName());
        }
        if (super.add(obj)) {
            if (obj instanceof Reaction) {
                ((Reaction)obj).setActive(false);
            }
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }
}

