/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.awt.Color;
import java.util.Set;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFragGenerator;
import pyrosim.domain.rasterization.RasterizationOptions;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.theUtil;

public class HoleFragGenerator
implements IFragGenerator<IHole> {
    private final RasterizationOptions d_options;
    public final IHole src;

    public HoleFragGenerator(IHole src, RasterizationOptions options) {
        this.d_options = options;
        this.src = src;
    }

    public int hashCode() {
        return theUtil.hashCode(this.src.isVisible()) + theUtil.hashCode(this.src.isEnabled()) + System.identityHashCode(this.getSignalSource(this.src)) + this.src.getEvac().hashCode() + (this.d_options.ignoreMergeNames ? 0 : this.src.getName().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HoleFragGenerator)) {
            return false;
        }
        HoleFragGenerator hash = (HoleFragGenerator)obj;
        return this.src.isVisible() == hash.src.isVisible() && this.src.isEnabled() == hash.src.isEnabled() && this.getSignalSource(this.src) == this.getSignalSource(hash.src) && this.src.getEvac().equals(hash.src.getEvac()) && (this.d_options.ignoreMergeNames || this.src.getName().equals(hash.src.getName()));
    }

    @Override
    public IGeom transformGeom(IGeom geom) {
        return geom;
    }

    @Override
    public IPrimProps generateDisplayProps(FaceProps fprops) {
        Color c = fprops.color;
        c = c == null ? Hole.DEF_COLOR : new Color(c.getRed(), c.getGreen(), c.getBlue(), 102);
        return new IPrimProps.Face(c, null, 2);
    }

    public IOutPin getSignalSource() {
        return this.getSignalSource(this.src);
    }

    private IOutPin getSignalSource(ISignalSink sink) {
        Set<? extends IOutPin> srcs = sink.getInputPin().getConnections();
        return srcs.isEmpty() ? null : srcs.iterator().next();
    }

    @Override
    public IHole generateFrag(IGeom geom, FaceProps[] faceProps) {
        Color[] colors;
        Hole ah = new Hole(this.src.getName(), GeomNodeUtil.newNode(geom));
        if (faceProps.length == 1) {
            colors = new Color[]{faceProps[0].color};
        } else {
            int numFaces = geom.getNumPrims(1);
            colors = new Color[numFaces];
            for (int m = 0; m < numFaces; ++m) {
                FaceProps prop = faceProps[m];
                colors[m] = prop.color;
            }
            if (GeomUtil.isUniform(colors)) {
                colors = new Color[]{colors[0]};
            }
        }
        ah.setColors(colors);
        ah.setVisible(this.src.isVisible());
        IOutPin srcPin = this.getSignalSource();
        if (srcPin != null) {
            ah.getInputPin().connect(srcPin);
        }
        ah.setEvac(this.src.getEvac());
        return ah;
    }
}

