/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.ramp;

import pyrosim.domain.INamed;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;

public class SignalInput
implements IRampInput {
    static final long serialVersionUID = 1L;
    public final IDoubleOutPin input;

    public SignalInput(IDoubleOutPin input) {
        this.input = input;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SignalInput)) {
            return false;
        }
        return this.input.equals(((SignalInput)obj).input);
    }

    @Override
    public String getName() {
        ISignalSource src = this.input.getAttachedSource();
        if (src instanceof INamed) {
            String srcName = ((INamed)((Object)src)).getName();
            return SignalInput.countDoubleOutputs(src) > 1 ? String.format("%s->%s", srcName, this.input.getName()) : srcName;
        }
        return this.input.getName();
    }

    @Override
    public int getUnitType() {
        return this.input.getUnitType();
    }

    private static int countDoubleOutputs(ISignalSource src) {
        int count = 0;
        for (IOutPin iOutPin : src.getOutputPins()) {
            if (!(iOutPin instanceof IDoubleOutPin)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public String getTVar() {
        return "T";
    }
}

