/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.quantity;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.StaticQuantity;
import pyrosim.util.Util;

public class ObjectQuantity<T extends IPyroObject>
extends StaticQuantity {
    static final long serialVersionUID = 1L;
    public final T[] objects;

    protected ObjectQuantity(Quantity quantity, T ... objects) {
        super(quantity);
        this.objects = objects;
    }

    @Override
    public int hashCode() {
        int code = 7811919 + super.hashCode();
        for (T obj : this.objects) {
            code += System.identityHashCode(obj);
        }
        return code;
    }

    @Override
    @SuppressFBWarnings(value={"EQ_CHECK_FOR_OPERAND_NOT_COMPATIBLE_WITH_THIS"})
    public boolean equals(Object obj) {
        assert (!(obj instanceof Quantity)) : "ObjectQuantity should not be directly compared to Quantity.";
        return obj == this || obj instanceof ObjectQuantity && super.equals(obj) && Arrays.equals(((ObjectQuantity)obj).objects, this.objects);
    }

    @Override
    public String getDescription() {
        StringBuffer objList = new StringBuffer();
        for (T obj : this.objects) {
            if (objList.length() > 0) {
                objList.append(", ");
            }
            objList.append(Util.getName(obj));
        }
        return String.format("[%1$s: %2$s] %3$s", this.quantity.category, objList.toString(), super.getDescription());
    }

    @Override
    public String toString() {
        return this.getDescription();
    }
}

