/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.INamed;
import pyrosim.domain.output.Slice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class VolumeSlice
extends Slice
implements INamed {
    private static final long serialVersionUID = 1L;
    private IGeom d_geom;
    @Deprecated
    private String d_name;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public VolumeSlice(String name, IGeom geom, IQuantity measurement, boolean includeFlowVector, boolean cellCentered) {
        super(measurement, includeFlowVector, cellCentered, name);
        assert (geom instanceof AABoxGeom);
        this.d_geom = geom;
    }

    public VolumeSlice(String name, UnitDouble minx, UnitDouble maxx, UnitDouble miny, UnitDouble maxy, UnitDouble minz, UnitDouble maxz, IQuantity measurement, boolean includeFlowVector, boolean cellCentered) {
        super(measurement, includeFlowVector, cellCentered, name);
        AABox box = new AABox(minx.getValue(Geometry.LU), miny.getValue(Geometry.LU), minz.getValue(Geometry.LU), maxx.getValue(Geometry.LU), maxy.getValue(Geometry.LU), maxz.getValue(Geometry.LU));
        this.d_geom = new AABoxGeom(box);
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        IGeom geom = this.getSliceGeom();
        IPrimProps.Face sprops = new IPrimProps.Face(s_color, null, 2);
        return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), (IPrimProps)sprops);
    }

    @Override
    public IGeom getSliceGeom() {
        if (this.d_geom instanceof AABoxGeom && !(this.d_geom instanceof BlockGeom)) {
            AABoxGeom aabox = (AABoxGeom)this.d_geom;
            return new BlockGeom(aabox.min, aabox.max);
        }
        return this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    @Override
    public void setGeom(IGeom geom) {
        if (AABoxGeom.class.isAssignableFrom(geom.getClass())) {
            this.d_geom = geom;
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 7;
        hashCode += 31 * hashCode + this.getQuantity().hashCode();
        hashCode += 31 * hashCode + this.d_geom.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        VolumeSlice s = (VolumeSlice)obj;
        return super.equals(s) && this.getGeom().equals(s.getGeom());
    }

    public VolumeSliceProxy getProxyRep() {
        UnitAABox bounds = GeomUtil.getUnitBounds(this);
        return new VolumeSliceProxy(this.getName(), bounds.getMin().xu(), bounds.getMax().xu(), bounds.getMin().yu(), bounds.getMax().yu(), bounds.getMin().zu(), bounds.getMax().zu(), this.getQuantity(), this.includeFlowVector(), this.isCellCentered());
    }

    public void restoreProps(VolumeSliceProxy proxy) {
        this.pauseUpdates();
        this.setGeom(new AABoxGeom(new AABox(proxy.minx.get(Geometry.LU), proxy.miny.get(Geometry.LU), proxy.minz.get(Geometry.LU), proxy.maxx.get(Geometry.LU), proxy.maxy.get(Geometry.LU), proxy.maxz.get(Geometry.LU))));
        this.setName(proxy.getName());
        this.setQuantity(proxy.getQuant());
        this.setCellCentered(proxy.isCellCentered());
        this.setIncludeFlowVector(proxy.isIncludeFlow());
        this.resumeUpdates();
    }

    public String toString() {
        return this.getName();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (this.getName() == null && this.d_name == null) {
            this.setName(this.getQuantity().getDescription());
        } else if (this.getName() == null) {
            this.setName(this.d_name);
        }
    }

    public String getPre152Name() {
        return this.d_name;
    }

    public static class VolumeSliceProxy {
        public String name;
        public UnitDouble minx;
        public UnitDouble maxx;
        public UnitDouble miny;
        public UnitDouble maxy;
        public UnitDouble minz;
        public UnitDouble maxz;
        public IQuantity quant;
        public boolean includeFlow;
        public boolean cellCentered;

        public VolumeSliceProxy(String name, UnitDouble minx, UnitDouble maxx, UnitDouble miny, UnitDouble maxy, UnitDouble minz, UnitDouble maxz, IQuantity quant, boolean includeFlow, boolean cellCentered) {
            this.name = name;
            this.quant = quant;
            this.minx = minx;
            this.miny = miny;
            this.minz = minz;
            this.maxx = maxx;
            this.maxy = maxy;
            this.maxz = maxz;
            this.includeFlow = includeFlow;
            this.cellCentered = cellCentered;
        }

        public UnitDouble getMinx() {
            return this.minx;
        }

        public UnitDouble getMiny() {
            return this.miny;
        }

        public UnitDouble getMinz() {
            return this.minz;
        }

        public UnitDouble getMaxx() {
            return this.maxx;
        }

        public UnitDouble getMaxy() {
            return this.maxy;
        }

        public UnitDouble getMaxz() {
            return this.maxz;
        }

        public String getName() {
            return this.name;
        }

        public IQuantity getQuant() {
            return this.quant;
        }

        public boolean isIncludeFlow() {
            return this.includeFlow;
        }

        public boolean isCellCentered() {
            return this.cellCentered;
        }

        public void setMinx(UnitDouble val) {
            this.minx = val;
        }

        public void setMiny(UnitDouble val) {
            this.miny = val;
        }

        public void setMinz(UnitDouble val) {
            this.minz = val;
        }

        public void setMaxx(UnitDouble val) {
            this.maxx = val;
        }

        public void setMaxy(UnitDouble val) {
            this.maxy = val;
        }

        public void setMaxz(UnitDouble val) {
            this.maxz = val;
        }

        public void setName(String val) {
            this.name = val;
        }

        public void setQuant(IQuantity val) {
            this.quant = val;
        }

        public void setIncludeFlow(boolean val) {
            this.includeFlow = val;
        }

        public void setCellCentered(boolean val) {
            this.cellCentered = val;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !(obj instanceof VolumeSliceProxy)) {
                return false;
            }
            VolumeSliceProxy asProxy = (VolumeSliceProxy)obj;
            return this.getMinx().equals(asProxy.getMinx()) && this.getMaxx().equals(asProxy.getMaxx()) && this.getMiny().equals(asProxy.getMiny()) && this.getMaxy().equals(asProxy.getMaxy()) && this.getMinz().equals(asProxy.getMinz()) && this.getMaxz().equals(asProxy.getMaxz()) && this.getName().equals(asProxy.getName()) && this.getQuant().equals(asProxy.getQuant()) && this.isCellCentered() == asProxy.isCellCentered() && this.isIncludeFlow() == asProxy.isIncludeFlow();
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.getMinx());
            hash = 31 * hash + theUtil.hashCode(this.getMaxx());
            hash = 31 * hash + theUtil.hashCode(this.getMiny());
            hash = 31 * hash + theUtil.hashCode(this.getMaxy());
            hash = 31 * hash + theUtil.hashCode(this.getMinz());
            hash = 31 * hash + theUtil.hashCode(this.getMaxz());
            hash = 31 * hash + theUtil.hashCode(this.getName());
            hash = 31 * hash + theUtil.hashCode(this.getQuant());
            hash = 31 * hash + theUtil.hashCode(this.isCellCentered());
            hash = 31 * hash + theUtil.hashCode(this.isIncludeFlow());
            return hash;
        }
    }
}

