/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.output;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class Slice
extends APyroObject
implements IPyroGeomSrc,
IDirectDependent,
ITaggable {
    static final long serialVersionUID = 1L;
    private IQuantity d_measurement;
    private boolean d_includeFlowVector;
    private boolean d_visible;
    private boolean d_cellCentered;
    private String d_customName;
    private Set<Tag> d_tags;
    private static final Color s_color = new Color(Color.PINK.getRed(), Color.PINK.getGreen(), Color.pink.getBlue(), 150);

    public Slice(IQuantity measurement, boolean includeFlowVector, boolean cellCentered, String name) {
        this.d_measurement = measurement;
        this.d_includeFlowVector = includeFlowVector;
        this.d_visible = true;
        this.d_cellCentered = cellCentered;
        this.d_tags = Collections.emptySet();
        this.setName(name);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_customName = "";
        this.d_visible = true;
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    public void setQuantity(IQuantity m) {
        this.d_measurement = m;
        this.changedEvt(new Object[0]);
    }

    public String getName() {
        return this.d_customName;
    }

    public void setName(String name) {
        if (!name.equals(this.d_customName)) {
            if (this.getDomain() != null) {
                ((PyroMod)this.getDomain()).getNames(this).updateRegisteredName(this.d_customName, name);
            }
            this.d_customName = name;
            this.changedEvt(new Object[0]);
        }
    }

    public boolean includeFlowVector() {
        return this.d_includeFlowVector;
    }

    public void setIncludeFlowVector(boolean include) {
        if (this.d_includeFlowVector == include) {
            return;
        }
        this.d_includeFlowVector = include;
        this.changedEvt(new Object[0]);
    }

    public boolean isCellCentered() {
        return this.d_cellCentered;
    }

    public void setCellCentered(boolean cellCentered) {
        if (this.d_cellCentered == cellCentered) {
            return;
        }
        this.d_cellCentered = cellCentered;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean isEquiv(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Slice) {
            Slice rec = (Slice)obj;
            return rec.d_includeFlowVector == this.d_includeFlowVector && rec.d_cellCentered == this.d_cellCentered && rec.d_measurement.equals(this.d_measurement) && Util.identitySetsEqual(this.getTags(), rec.getTags());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.d_measurement.hashCode();
        hash = 31 * hash + (this.d_cellCentered ? 1 : 0);
        hash = 31 * hash + (this.d_includeFlowVector ? 1 : 0);
        hash = 31 * hash + this.d_customName.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Slice) {
            Slice rec = (Slice)obj;
            return Objects.equals(rec.d_customName, this.d_customName) && rec.d_includeFlowVector == this.d_includeFlowVector && rec.d_cellCentered == this.d_cellCentered && rec.d_measurement.equals(this.d_measurement) && Util.identitySetsEqual(this.getTags(), rec.getTags());
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getSliceGeom());
    }

    public IGeom getSliceGeom() {
        return EmptyGeom.INSTANCE;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), (IPrimProps)new IPrimProps.Face(s_color, null, 0));
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.getQuantity());
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Tag) {
            ITaggable.removeInvalidTagReplacements(old, objs);
        } else {
            QuantReplacer replacer = new QuantReplacer();
            replacer.removeInvalidReplacements(old, objs, this.getQuantity());
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof Tag) {
            return ITaggable.taskReplaceTagDep(old, replacement, this);
        }
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.getQuantity());
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Slice.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    Slice.this.setQuantity(obj);
                }
            };
        }
    }
}

