/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.util.Collection;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.bridge.ABridgeObj;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import thunderheadeng.units.UnitDouble;

public class HvacDuctLoss
extends ABridgeObj {
    static final long serialVersionUID = 1L;
    public final HvacNode node;
    public final HvacDuct duct1;
    public final HvacDuct duct2;
    public final UnitDouble fwdLoss;
    public final UnitDouble revLoss;

    public HvacDuctLoss(HvacNode node, HvacDuct duct1, HvacDuct duct2, UnitDouble fwdLoss, UnitDouble revLoss) {
        this.node = node;
        this.duct1 = duct1;
        this.duct2 = duct2;
        this.fwdLoss = fwdLoss;
        this.revLoss = revLoss;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HvacDuctLoss)) {
            return false;
        }
        HvacDuctLoss hdl = (HvacDuctLoss)obj;
        return (hdl.duct1 == this.duct1 && hdl.duct2 == this.duct2 || hdl.duct1 == this.duct2 && hdl.duct2 == this.duct1) && hdl.getLoss(this.duct1).equals(this.getLoss(this.duct1)) && hdl.getLoss(this.duct2).equals(this.getLoss(this.duct2));
    }

    public int hashCode() {
        return 0x324F83FA ^ this.node.hashCode() + this.duct1.hashCode() + this.duct2.hashCode() + this.fwdLoss.hashCode() + this.revLoss.hashCode();
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    public UnitDouble getLoss(HvacDuct source) {
        if (source == this.duct1) {
            return this.fwdLoss;
        }
        if (source == this.duct2) {
            return this.revLoss;
        }
        return null;
    }

    public HvacDuct otherDuct(HvacDuct duct) {
        if (duct == this.duct1) {
            return this.duct2;
        }
        if (duct == this.duct2) {
            return this.duct1;
        }
        return null;
    }

    @Override
    public void getBridgedObjects(Collection<IPyroObject> objs) {
        objs.add(this.node);
        objs.add(this.duct1);
        objs.add(this.duct2);
    }
}

