/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import java.util.Objects;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Global;

public class PointNormalPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Point3d point;
    public final Vector3d normal;

    public PointNormalPlane(Point3d p, Vector3d n) {
        this.point = p;
        this.normal = n;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PointNormalPlane)) {
            return false;
        }
        PointNormalPlane p = (PointNormalPlane)obj;
        return p.point.equals(this.point) && p.normal.equals(this.normal);
    }

    public int hashCode() {
        return 153307386 + Objects.hash(this.point, this.normal);
    }

    @Override
    public Plane3d get() {
        return new Plane3d(this.normal, this.point);
    }

    @Override
    public String toString(Unit lu) {
        UnitPoint3D p = new UnitPoint3D(this.point, Geometry.LU).convert(lu);
        return String.format(Intl.intl("point=(%s, %s, %s) %s, normal=(%s, %s, %s)"), Global.format(p.x()), Global.format(p.y()), Global.format(p.z()), lu.toString(), Global.format(this.normal.x), Global.format(this.normal.y), Global.format(this.normal.z));
    }
}

