/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom.plane;

import java.io.Serializable;
import org.jscience.physics.units.Unit;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.theUtil;

public class EuclideanPlane
implements IPlane,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double x;
    public final double y;
    public final double z;
    public final double w;

    public EuclideanPlane(double x, double y, double z, double w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof EuclideanPlane)) {
            return false;
        }
        EuclideanPlane p = (EuclideanPlane)obj;
        return p.x == this.x && p.y == this.y && p.z == this.z && p.w == this.w;
    }

    public int hashCode() {
        return 0x398FAD23 ^ theUtil.hashCode(this.x) + theUtil.hashCode(this.y) + theUtil.hashCode(this.z) + theUtil.hashCode(this.w);
    }

    @Override
    public Plane3d get() {
        Plane3d result = new Plane3d(this.x, this.y, this.z, this.w);
        return result.normalize();
    }

    private static String format(double val, Unit lu) {
        return Global.format(UnitDouble.convert(val, Geometry.LU, lu), lu);
    }

    @Override
    public String toString(Unit lu) {
        return String.format("%s, %s, %s, %s", Global.format(this.x), Global.format(this.y), Global.format(this.z), EuclideanPlane.format(this.w, lu));
    }
}

