/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.geom;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.GridMergeUtil;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.boundcond.surf.BurnerSurfDesc;
import pyrosim.domain.boundcond.surf.Fuel;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.geom.AFDSObject;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.rasterization.IFDSObjProps;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.geom.IPyroDisplayProps;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.Rectifier;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.DisplayGeomBuilder;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.LineConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.Filters;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Vent
extends AFDSObject
implements ISurfObj {
    static final long serialVersionUID = 1L;
    public static final int OPTION_OUTLINE = 1;
    public static final int ALL_OPTIONS = 1;
    public static final int DEF_OPTIONS = 0;
    private AARectangle d_quad;
    private Vector3d d_normal;
    private Surface d_surf;
    private TexOrigin d_texOrigin;
    private Object d_texMapper;
    private Vector3d d_louver;
    private OpenProps d_openProps;
    private UnitDouble d_spreadRate;
    private UnitPoint3D d_centerPoint;
    private UnitDouble d_radius;
    public static final Composite.AObjectProp<Vent, Surface> surfProp;

    public Vent(String name, Surface mat) {
        this(name, mat, new AARectangle(2, 0.0, 0.0, 0.0, 1.0, 1.0, false), null, null);
    }

    public Vent(String name, Surface mat, AARectangle geom) {
        this(name, mat, geom, null, null);
    }

    public Vent(String name, Surface mat, AARectangle geom, UnitDouble spreadRate, UnitPoint3D centerPoint) {
        super(name);
        this.d_quad = new AARectangle(geom.d_plane, geom.d_planeVal, geom.d_minx, geom.d_miny, geom.d_maxx, geom.d_maxy, geom.flipped);
        assert (!(this.d_quad instanceof VentGeom));
        this.d_surf = mat;
        this.d_normal = geom instanceof VentGeom ? ((VentGeom)geom).normal : null;
        this.d_spreadRate = spreadRate;
        this.d_centerPoint = centerPoint;
        this.d_radius = geom instanceof VentGeom ? ((VentGeom)geom).radius : null;
        this.d_texOrigin = TexOrigin.defaultWorld();
        this.d_texMapper = FDSUtil.getDefaultTexMapperSets();
        this.setOptions(0, true);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_texMapper instanceof IElemSource) {
            IElemSource uv = (IElemSource)this.d_texMapper;
            this.d_texMapper = uv == Elements.NO_UV ? Collections.emptyMap() : Collections.singletonMap("uvset", uv);
        }
    }

    public static Predicate<Surface> getSurfaceFilter() {
        return Filters.acceptAll();
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("VENT");
    }

    @Override
    public boolean isControllable() {
        return Vent.isControllableSurf(this.d_surf);
    }

    public static boolean isControllableSurf(Surface surf) {
        return !surf.isPredefined(PredefSurf.OPEN) && !surf.isPredefined(PredefSurf.MIRROR) && !surf.isPredefined(PredefSurf.HVAC);
    }

    private static int filterOptions(int options) {
        return options & 1;
    }

    public void setOptions(int options, boolean set) {
        this.setFlags(Vent.filterOptions(options), set, new Object[0]);
    }

    public boolean getOptions(int options) {
        return this.testFlags(Vent.filterOptions(options));
    }

    public int getSetOptions() {
        return Vent.filterOptions(super.getSetFlags());
    }

    public Vector3d getLouver() {
        return this.d_louver;
    }

    public void setLouver(Vector3d louver) {
        if (theUtil.equal(this.d_louver, louver)) {
            return;
        }
        this.d_louver = louver;
        this.changedEvt(new Object[0]);
    }

    public void setNormal(Vector3d normal) {
        this.d_normal = normal;
        this.changedEvt(new Object[0]);
    }

    public Vector3d getNormal() {
        return this.d_normal;
    }

    @Override
    public TexOrigin getTextureOrigin() {
        return this.d_texOrigin;
    }

    @Override
    public void setTextureOrigin(TexOrigin origin) {
        this.d_texOrigin = origin;
        this.changedEvt(new Object[0]);
    }

    public void setOpenProps(OpenProps props) {
        this.d_openProps = props;
        this.changedEvt(new Object[0]);
    }

    public OpenProps getOpenProps() {
        return this.d_openProps;
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public Surface[] getSurfaces() {
        return new Surface[]{this.getSurface()};
    }

    @Override
    public void setSurfaces(Surface[] surfs) {
        assert (surfs.length == 1);
        this.setSurface(surfs[0]);
    }

    @Override
    public Predicate<Surface> getSurfFilter() {
        if (this.d_surf.isPredefined(PredefSurf.HVAC)) {
            return Filters.accept(this.d_surf);
        }
        return Vent.getSurfaceFilter();
    }

    public Surface getSurface() {
        return this.d_surf;
    }

    public void setSurface(Surface surf) {
        if (this.d_surf == surf) {
            return;
        }
        this.d_surf = surf;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IFDSObjProps getFragGenerator() {
        return null;
    }

    @Override
    public IModelObj getRestoreObject() {
        return (Vent)this.clone();
    }

    @Override
    public void imprint(IModelObj obj) {
        if (!(obj instanceof Vent)) {
            assert (false);
        } else {
            Vent refVent = (Vent)obj;
            this.pauseUpdates();
            super.imprint(obj);
            this.setSurfaces(refVent.getSurfaces());
            this.setFireSpreadRate(refVent.getFireSpreadRate());
            this.setCenterPoint(refVent.getCenterPoint());
            this.setNormal(refVent.getNormal());
            this.setTextureOrigin(refVent.getTextureOrigin());
            this.setTexMappers(refVent.getTexMappers());
            this.setLouver(refVent.getLouver());
            this.setOpenProps(refVent.getOpenProps());
            this.resumeUpdates();
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps dispProps) {
        Vent d_vent = this;
        DisplayGeom dg = this.getBaseDisplayGeom(dispProps);
        if (d_vent.getOptions(1) || !(dispProps instanceof IPyroDisplayProps)) {
            return dg;
        }
        IPyroDisplayProps pyroProps = (IPyroDisplayProps)dispProps;
        boolean modified = false;
        IGeomNode fnode = dg.node.flatten();
        List<IPrimitive> prims = GeomUtil.explodeToTypes(fnode.getLocalGeom(), 7);
        DisplayGeomBuilder dgbuilder = new DisplayGeomBuilder();
        for (int m = 0; m < prims.size(); ++m) {
            Elements.Orient currOrient;
            Elements.Orient newOrient;
            IPrimitive prim = prims.get(m);
            IPrimProps pp = dg.props.get(m);
            IPropertySet elements = Elements.getPrimElements(fnode.getLocalElements(), m);
            if (prim instanceof IFace && (newOrient = this.getCullOrient(pyroProps, (IFace)prim, currOrient = (Elements.Orient)((Object)((IElemSource)((Object)elements.get(Elements.ORIENT))).getPrimElement(0)))) != null) {
                modified = true;
                int options = pp.getOptions() | 2;
                pp = pp.setOptions(options);
                elements = Elements.copyOf(elements);
                elements.setIfNotDefault(Elements.ORIENT, newOrient == Elements.Orient.CCW ? Elements.CCW : Elements.CW);
                elements = Elements.finalizeElements(elements);
            }
            dgbuilder.add((IGeom)prim, new UniformProps(pp), elements);
        }
        if (!modified) {
            return dg;
        }
        return dgbuilder.finish().toDisplay();
    }

    private Elements.Orient getCullOrient(IPyroDisplayProps pyroProps, IFace face, Elements.Orient orient) {
        Vent d_vent = this;
        if (d_vent.getOptions(1)) {
            return null;
        }
        if (!(face instanceof IPolygon)) {
            return null;
        }
        Vector3d ventNorm = d_vent.getNormal();
        if (ventNorm == null) {
            GridMergeUtil.MergeResult mr = pyroProps.getMergedMeshes();
            if (mr == null) {
                return null;
            }
            Point3d center = face.getBoundingBox(new AABox()).getCenter();
            Iterator<Face> iterator = mr.model.findFaces(new AABox(center)).iterator();
            if (iterator.hasNext()) {
                Face gridFace = iterator.next();
                ventNorm = Util3D.negate(gridFace.plane.getNormal());
            }
            if (ventNorm == null) {
                return null;
            }
        }
        assert (ventNorm != null);
        IPolygon poly = (IPolygon)face;
        Vector3d polyNorm = poly.getNormal(orient.isCCW());
        if (ventNorm.epsilonEquals(polyNorm, 1.0E-9)) {
            return orient;
        }
        return orient.flip();
    }

    private DisplayGeom getBaseDisplayGeom(IDisplayProps drawProps) {
        IPyroDisplayProps pyroProps = drawProps instanceof IPyroDisplayProps ? (IPyroDisplayProps)drawProps : null;
        DisplayGeomBuilder dgbuilder = new DisplayGeomBuilder();
        VentGeom vgeom = this.getVentGeom();
        IGeomNode node = GeomNodeUtil.newNode(vgeom, Elements.newElements(Elements.UV, this.getTexMappers()));
        node = FDSUtil.finalizeUVElements(node, this.d_texOrigin);
        Color color = this.getColors()[0];
        IPrimProps.Face faceProps = FDSUtil.newObstFaceProps(color, this.getSurface(), 0);
        dgbuilder.add(node.getLocalGeom(), faceProps, node.getLocalElements());
        if (vgeom.normal != null && (pyroProps == null || pyroProps.getVentOrientVisible())) {
            AABox bb = vgeom.getBoundingBox(new AABox());
            Point3d mid = Util3D.getMidPoint(bb.getMin(), bb.getMax());
            Point3d normalEndpoint = new Point3d(vgeom.normal);
            normalEndpoint.scale(Vent.getNormalDistFromCenter(bb));
            normalEndpoint.add(mid);
            LineSeg seg = new LineSeg(mid, normalEndpoint);
            dgbuilder.add((IGeom)seg, new UniformProps(new IPrimProps.Edge(Color.BLACK, 1.0, IPrimProps.DEF_STIPPLE, 0)), Elements.NONE);
        }
        DisplayGeom dispGeom = dgbuilder.finish().toDisplay();
        if (this.getOptions(1)) {
            dispGeom = GeomUtil.convertToOutline(dispGeom);
        }
        return dispGeom;
    }

    public static double getNormalDistFromCenter(AABox bounds) {
        double xdiff = bounds.getWidth();
        double ydiff = bounds.getDepth();
        double zdiff = bounds.getHeight();
        double largest = Double.MIN_VALUE;
        if (xdiff > largest) {
            largest = xdiff;
        }
        if (ydiff > largest) {
            largest = ydiff;
        }
        if (zdiff > largest && zdiff > 0.0) {
            largest = zdiff;
        }
        return largest * 0.25;
    }

    @Override
    public IGeomNode getGeom() {
        IPropertySet elems = Elements.newElements(Elements.UV, this.getTexMappers());
        return GeomNodeUtil.newNode(this.getVentGeom(), elems);
    }

    public VentGeom getVentGeom() {
        return new VentGeom(this);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        geom = geom.flatten();
        this.pauseUpdates();
        this.setGeom(geom.getLocalGeom());
        this.setTexMappers(geom.getLocalElements().get(Elements.UV));
        this.resumeUpdates();
    }

    public void setTexMappers(Map<String, IElemSource<Point2d>> uvSets) {
        if (Objects.equals(uvSets, this.d_texMapper)) {
            return;
        }
        this.d_texMapper = uvSets;
        this.changedEvt(new Object[0]);
    }

    public Map<String, IElemSource<Point2d>> getTexMappers() {
        return (Map)this.d_texMapper;
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof VentGeom) {
            VentGeom vg = (VentGeom)geom;
            this.d_quad = new AARectangle(vg.d_plane, vg.d_planeVal, vg.d_minx, vg.d_miny, vg.d_maxx, vg.d_maxy, vg.flipped);
            this.d_normal = vg.normal;
            this.d_centerPoint = vg.centerPoint;
            this.d_radius = vg.radius;
            this.d_louver = vg.louver;
            this.changedEvt(new Object[0]);
        } else if (geom instanceof AARectangle) {
            this.pauseUpdates();
            this.d_quad = (AARectangle)geom;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    public UnitPoint3D getDefaultCenterPoint() {
        AABox bounds = new AABox();
        this.getGeom().getBoundingBox(bounds);
        return new UnitPoint3D((bounds.getMaxX() + bounds.getMinX()) / 2.0, (bounds.getMaxY() + bounds.getMinY()) / 2.0, (bounds.getMaxZ() + bounds.getMinZ()) / 2.0, PyroSim.getApp().getUnitSystem().getLengthUnit());
    }

    public UnitDouble getFireSpreadRate() {
        if (Vent.isValidFireSpreadSurf(this.d_surf)) {
            return this.d_spreadRate;
        }
        return null;
    }

    public void setFireSpreadRate(UnitDouble spread) {
        this.d_spreadRate = spread;
        this.changedEvt(new Object[0]);
    }

    public UnitPoint3D getCenterPoint() {
        return this.d_centerPoint;
    }

    public void setCenterPoint(UnitPoint3D p3d) {
        this.d_centerPoint = p3d;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getRadius() {
        return this.d_radius;
    }

    public void setRadius(UnitDouble radius) {
        this.d_radius = radius;
        this.changedEvt(new Object[0]);
    }

    public static boolean isValidFireSpreadSurf(Surface surf) {
        if (surf == null) {
            return false;
        }
        if (surf.getSurfDesc() instanceof BurnerSurfDesc) {
            return true;
        }
        if (surf.getSurfDesc() instanceof LayeredSurfDesc) {
            LayeredSurfDesc desc = (LayeredSurfDesc)surf.getSurfDesc();
            return desc.d_iReac instanceof Fuel.ManualReac;
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.REQUIRED, (IPyroObject)this.d_surf);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old == this.d_surf) {
            Util.keepIfNullOr(objs, Surface.class);
        } else if (old instanceof ExSpec) {
            Util.keepIfNullOr(objs, ExSpec.class);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (!(dep instanceof Surface) && Util.containsAny(changes, Surface.EVT_APPEARANCE, Surface.EVT_COLOR, EventChannel.EVT_GENERAL)) {
            return super.taskUpdateDep(dep, changes);
        }
        return GeomUtil.taskChanged(this);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof Surface) {
            return new AReplaceRefTask<Surface>((Object)old, (Object)replacement){

                @Override
                protected void set(Surface obj) {
                    Vent.this.setSurface(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(Surface.class);
        surfProp = new Composite.AObjectProp<Vent, Surface>(Vent.class){

            @Override
            public void set(Vent obj, Surface prop) {
                obj.setSurface(prop);
            }

            @Override
            public Object get(Vent obj) {
                return obj.getSurface();
            }
        };
    }

    public static class VentGeom
    extends AARectangle {
        static final long serialVersionUID = -7721415650741267503L;
        public final Vector3d normal;
        public final Vector3d louver;
        public final UnitDouble radius;
        public final UnitPoint3D centerPoint;

        public VentGeom(Vent vent) {
            this(vent.d_quad, vent.d_normal, vent.d_centerPoint, vent.d_louver, vent.d_radius);
        }

        public VentGeom(AARectangle rect, Vector3d normal, UnitPoint3D centerPoint, Vector3d louver, UnitDouble radius) {
            super(rect.d_plane, rect.d_planeVal, rect.d_minx, rect.d_miny, rect.d_maxx, rect.d_maxy, rect.flipped);
            this.normal = normal;
            this.louver = louver;
            this.radius = radius;
            this.centerPoint = centerPoint;
        }

        public AARectangle optimize(HashPool<Point3d> pool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IPolygon transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            AABox bounds = new AABox();
            super.getBoundingBox(bounds);
            Point3d newMin = Util3D.xform(xform, bounds.getMin());
            Point3d newMax = Util3D.xform(xform, bounds.getMax());
            Rectifier.rectify(newMin, newMax);
            AARectangle rect = AARectangle.construct(newMin, newMax, 1.0E-9, false);
            if (rect == null) {
                return this;
            }
            Vector3d newNormal = this.normal;
            if (this.normal != null) {
                newNormal = Util3D.xform(xform, this.normal);
                newNormal.normalize();
            }
            UnitPoint3D newCenterPoint = this.centerPoint;
            if (this.centerPoint != null) {
                newCenterPoint = Geometry.xform(xform, this.centerPoint);
            }
            Vector3d newLouver = this.louver == null ? null : Util3D.xform(xform, this.louver);
            return new VentGeom(rect, newNormal, newCenterPoint, newLouver, this.radius);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            super.generateManipHandles(handles);
            handles.accept(new NormalHandle(this));
        }

        private static class NormalHandle
        implements IHandle {
            private VentGeom geom;

            public NormalHandle(VentGeom geom) {
                this.geom = geom;
            }

            public boolean equals(Object obj) {
                return obj instanceof NormalHandle;
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return null;
            }

            protected Point3d getMidPoint() {
                AABox bb = this.geom.getBoundingBox(new AABox());
                Point3d min = bb.getMin();
                Point3d max = bb.getMax();
                return Util3D.getMidPoint(min, max);
            }

            @Override
            public IGeomNode getGeom() {
                return GeomNodeUtil.newNode(new Point(this.getLocation()));
            }

            protected Point3d getLocation() {
                Point3d mid = this.getMidPoint();
                Vector3d normalU = this.geom.normal;
                if (normalU != null) {
                    Vector3d normal = new Vector3d(normalU);
                    normal.scale(this.getNormalDistFromCenter());
                    mid.add(normal);
                }
                return mid;
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return new LineConstraint(handleLoc, this.geom.getNormal(true));
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
            }

            @Override
            public VentGeom modify(IsectInfo constraintInfo, Point3d newLoc) throws ManipException {
                Vector3d normal = this.geom.getNormal(true);
                Point3d mid = this.getMidPoint();
                double dist = Util3D.tOnLine(mid, normal, newLoc);
                Vector3d newNormal = Math.abs(dist) < this.getNormalDistFromCenter() * 0.5 ? null : Util3D.scale(normal, Math.signum(dist));
                this.geom = new VentGeom(this.geom, newNormal, this.geom.centerPoint, this.geom.louver, this.geom.radius);
                return this.geom;
            }

            @Override
            public Object end() {
                return this.geom;
            }

            public double getNormalDistFromCenter() {
                return Vent.getNormalDistFromCenter(this.geom.getBoundingBox(new AABox()));
            }
        }
    }

    public static class OpenProps
    implements Serializable {
        static final long serialVersionUID = 1L;
        public static final OpenProps DEFAULT = new OpenProps(null, new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SIUS.unit(39)), TimeFunction.newDefault()));
        public final UnitDouble temp;
        public final TimeBasedValue<UnitDouble> pressure;

        public OpenProps(UnitDouble temp, TimeBasedValue<UnitDouble> pressure) {
            this.temp = temp;
            this.pressure = pressure;
        }
    }

    public static class OptionProp
    extends Composite.AObjectProp<Vent, Boolean> {
        private final int d_option;

        public OptionProp(int option) {
            super(Vent.class);
            this.d_option = option;
        }

        @Override
        public void set(Vent obj, Boolean prop) {
            obj.setOptions(this.d_option, prop);
        }

        @Override
        public Object get(Vent obj) {
            return obj.getOptions(this.d_option);
        }
    }
}

