/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.statistics;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.geom.Geometry;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.APrimitive;
import thunderheadeng.geometry.objs.BlockGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.TriFunction;
import thunderheadeng.util.theUtil;

public sealed interface IStatGeom
extends IGeom,
Serializable {
    public static final int NUM_ARRAY_OUTPUTS = 100;
    public static final Tuple3d POINT_ARRAY = GeomConstants.PNT3D_ORIGIN;

    public static int getNumDevcOutputs(ArrayProfile arrayProfile) {
        if (arrayProfile == null) {
            return 1;
        }
        return arrayProfile.numOutputs;
    }

    public Type getType();

    default public boolean isSpatial() {
        return this.getType().isSpatial();
    }

    default public boolean isArray() {
        return this.getType().array;
    }

    public int getNumPoints();

    public ArrayProfile getArrayProfile();

    default public int getNumDevcOutputs() {
        return IStatGeom.getNumDevcOutputs(this.getArrayProfile());
    }

    default public int getNumEnabledDevcOutputs() {
        ArrayProfile profile = this.getArrayProfile();
        if (profile == null) {
            return this.getNumPoints();
        }
        return Math.min(this.getNumPoints(), profile.maxEnabledOutputs);
    }

    public DisplayGeom getDisplayGeom(IDisplayProps var1, Color var2);

    public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies();

    public boolean equals(Object var1);

    public boolean surrogateEquals(IStatGeom var1);

    public static enum ArrayProfile {
        TIME_VARYING(Intl.intl("Time-Varying"), Intl.intl("Creates an array of devices that can be used as input to other devices and controls."), 100, 100),
        STEADY_STATE(Intl.intl("Steady-State"), Intl.intl("Creates an array of devices whose steady-state values are written to '*_line.csv'.\nCannot be used as inputs to other devices/controls."), 100, 0);

        public final String name;
        public final String description;
        public final int numOutputs;
        public final int maxEnabledOutputs;

        private ArrayProfile(String name, String description, int numOutputs, int maxEnabledOutputs) {
            this.name = name;
            this.description = description;
            this.numOutputs = numOutputs;
            this.maxEnabledOutputs = maxEnabledOutputs;
        }
    }

    public static enum Type {
        POINT(Intl.intl("Point"), "", null, false, geom -> {
            Point point;
            if (geom instanceof thunderheadeng.geometry.objs.Point) {
                thunderheadeng.geometry.objs.Point p = (thunderheadeng.geometry.objs.Point)geom;
                point = new Point(p.loc);
            } else {
                point = null;
            }
            return point;
        }),
        RECTANGLE(Intl.intl("Plane"), "", SpatialType.AREA, false, geom -> {
            Rectangle rectangle;
            if (geom instanceof AARectangle) {
                AARectangle r = (AARectangle)geom;
                rectangle = new Rectangle(r);
            } else {
                rectangle = null;
            }
            return rectangle;
        }),
        BOX(Intl.intl("Volume"), "", SpatialType.VOLUME, false, geom -> {
            Box box;
            if (geom instanceof AABoxGeom) {
                AABoxGeom boxGeom = (AABoxGeom)geom;
                box = new Box(boxGeom.min, boxGeom.max, boxGeom.swizzle, boxGeom.cw);
            } else {
                box = null;
            }
            return box;
        }),
        GRID(Intl.intl("Mesh"), "", SpatialType.VOLUME, false, geom -> null),
        POINT_ARRAY(Intl.intl("Point Array"), Intl.intl("A line of devices that each measure a Point."), null, true, geom -> {
            LinearArray linearArray;
            if (geom instanceof LineSeg) {
                LineSeg ls = (LineSeg)geom;
                linearArray = new LinearArray(ArrayProfile.TIME_VARYING, ls.p1, ls.p2, GeomConstants.PNT3D_ORIGIN, 2);
            } else {
                linearArray = null;
            }
            return linearArray;
        }),
        BOX_ARRAY(Intl.intl("Box Array"), Intl.intl("A line of devices that each measure a Volume"), SpatialType.VOLUME, true, geom -> null);

        public final String name;
        public final String tooltip;
        public final SpatialType spatial;
        public final boolean array;
        public final Function<? super IGeom, ? extends IStatGeom> toStatGeom;

        private Type(String displayName, String tooltip, SpatialType spatial, boolean array, Function<? super IGeom, ? extends IStatGeom> toStatGeom) {
            this.name = displayName;
            this.tooltip = tooltip;
            this.spatial = spatial;
            this.array = array;
            this.toStatGeom = toStatGeom;
        }

        public boolean isSpatial() {
            return this.spatial != null;
        }
    }

    public static final class LinearArray
    extends LineSeg
    implements IStatGeom {
        static final long serialVersionUID = 1L;
        public final ArrayProfile profile;
        public final int numPoints;
        public final Tuple3d delta;

        public LinearArray(ArrayProfile profile, Point3d p1, Point3d p2, Tuple3d delta, int numPoints) {
            super(p1, p2);
            this.profile = profile;
            this.numPoints = numPoints;
            this.delta = delta;
        }

        @Override
        public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public int getNumPoints() {
            return this.numPoints;
        }

        @Override
        public ArrayProfile getArrayProfile() {
            return this.profile;
        }

        @Override
        public Type getType() {
            return this.delta.equals(GeomConstants.PNT3D_ORIGIN) ? Type.POINT_ARRAY : Type.BOX_ARRAY;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(LineSeg seg, boolean compareOrient) {
            if (!super.equals(seg, compareOrient)) return false;
            if (!(seg instanceof LinearArray)) return false;
            LinearArray lag = (LinearArray)seg;
            if (!lag.delta.equals(this.delta)) return false;
            if (lag.numPoints != this.numPoints) return false;
            if (lag.profile != this.profile) return false;
            return true;
        }

        @Override
        public boolean surrogateEquals(IStatGeom geom) {
            return this.equals(geom);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps drawProps, Color color) {
            LinearArray geom = this;
            if (this.isSpatial()) {
                IPrimProps.Face props = new IPrimProps.Face(color, null, 2);
                ArrayList<IGeom> geoms = new ArrayList<IGeom>();
                PropsBuilder gprops = new PropsBuilder();
                geoms.add(geom);
                gprops.add(new IPrimProps.Edge(color, 3.0, IPrimProps.DEF_STIPPLE, 0));
                Point3d[] r = LinearArray.calcPointArray(geom.p1, geom.p2, geom.numPoints);
                Tuple3d delta = geom.delta;
                for (Point3d p : r) {
                    geoms.add(new AABoxGeom(new AABox(p.x - delta.x, p.y - delta.y, p.z - delta.z, p.x + delta.x, p.y + delta.y, p.z + delta.z)));
                    gprops.add(props, 6);
                }
                IGeom geometry = GeomUtil.group(geoms);
                GeomNodeLeaf node = GeomNodeUtil.newNode(geometry);
                return new DisplayGeom((IGeomNode)node, gprops.finalizeProps());
            }
            ArrayList<APrimitive> geoms = new ArrayList<APrimitive>();
            PropsBuilder gprops = new PropsBuilder();
            geoms.add(this);
            gprops.add(new IPrimProps.Edge(color, 3.0, IPrimProps.DEF_STIPPLE, 0));
            Point3d[] r = LinearArray.calcPointArray(geom.p1, geom.p2, geom.numPoints);
            IPrimProps.Vertex pointProp = new IPrimProps.Vertex(color, 10.0);
            for (Point3d p : r) {
                geoms.add(new Point(p));
                gprops.add(pointProp);
            }
            IGeom geometry = GeomUtil.group(geoms);
            GeomNodeLeaf node = GeomNodeUtil.newNode(geometry);
            return new DisplayGeom((IGeomNode)node, gprops.finalizeProps());
        }

        private static Point3d[] calcPointArray(Point3d p1, Point3d p2, int numPoints) {
            Point3d[] r = new Point3d[numPoints];
            double dx = (p2.x - p1.x) / (double)(numPoints - 1);
            double dy = (p2.y - p1.y) / (double)(numPoints - 1);
            double dz = (p2.z - p1.z) / (double)(numPoints - 1);
            r[0] = p1;
            r[numPoints - 1] = p2;
            for (int i = 1; i < numPoints - 1; ++i) {
                r[i] = new Point3d(p1.x + dx * (double)i, p1.y + dy * (double)i, p1.z + dz * (double)i);
            }
            return r;
        }

        @Override
        public LinearArray newCurve(Point3d ... points) {
            assert (points.length == 2);
            return new LinearArray(this.profile, points[0], points[1], this.delta, this.numPoints);
        }
    }

    public static final class GridGeom
    implements IStatGeom {
        static final long serialVersionUID = 1L;
        public final Grid grid;

        public GridGeom(Grid grid) {
            this.grid = grid;
        }

        public int hashCode() {
            return this.grid.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            GridGeom g = (GridGeom)obj;
            return g.grid == this.grid;
        }

        @Override
        public boolean surrogateEquals(IStatGeom obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            GridGeom g = (GridGeom)obj;
            return g.grid.equals(this.grid);
        }

        @Override
        public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies() {
            DependencyInfo<Grid> gridDep = new DependencyInfo<Grid>(Grid.class, (source, deps) -> deps.add(DLink.WEAK, (IPyroObject)this.grid), (source, old, objs) -> Util.keepIfNullOr(objs, Grid.class), (source, old, repl) -> {
                if (old != this.grid) {
                    return null;
                }
                if (repl != null) {
                    return new GridGeom((Grid)repl);
                }
                return new Box(old.getMinPoint().getPoint3dValue(Geometry.LU), old.getMaxPoint().getPoint3dValue(Geometry.LU));
            });
            return Stream.of(gridDep);
        }

        @Override
        public int getNumPoints() {
            return 1;
        }

        @Override
        public ArrayProfile getArrayProfile() {
            return null;
        }

        @Override
        public Type getType() {
            return Type.GRID;
        }

        protected AABoxGeom toBox() {
            if (this.grid != null) {
                return new AABoxGeom(this.grid.getGeom().getBoundingBox(new AABox()));
            }
            return new AABoxGeom(new AABox(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
        }

        @Override
        public boolean canExplode() {
            return true;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            prims.add(this.toBox());
            return prims;
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            return this.grid.getGeom().getBoundingBox(aabb);
        }

        @Override
        public int getNumPrims(int types) {
            if ((types & 1) != 0) {
                return 6;
            }
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return theUtil.iterate((byte)1, 6 - offset);
        }

        @Override
        public boolean isShell() {
            return Boolean.FALSE;
        }

        @Override
        public IGeom optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.NONE;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.NONE;
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return true;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            return this;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
            this.toBox().pickPoints(isects, filter, source, creases, rayBegin, rayDirN, maxDist, tester);
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
            this.toBox().pickBox(source, visFaceEdges, filter, region, isects);
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
            this.toBox().find(test, result);
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
            this.toBox().getAll(result);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps drawProps, Color color) {
            IPrimProps.Face props = new IPrimProps.Face(color, null, 2);
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this), (IPrimProps)props);
        }
    }

    public static final class Box
    extends BlockGeom
    implements IStatGeom {
        private static final long serialVersionUID = 1L;

        public Box(Point3d min, Point3d max) {
            super(min, max);
        }

        public Box(Point3d min, Point3d max, short swizzle, boolean cw) {
            super(min, max, swizzle, cw);
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Box && super.equals(obj);
        }

        @Override
        public boolean surrogateEquals(IStatGeom geom) {
            return this.equals(geom);
        }

        @Override
        public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public int getNumPoints() {
            return 1;
        }

        @Override
        public ArrayProfile getArrayProfile() {
            return null;
        }

        @Override
        public Type getType() {
            return Type.BOX;
        }

        @Override
        public AABoxGeom modify(Point3d min, Point3d max, int swizzle, boolean cw) {
            return new Box(min, max, (short)swizzle, cw);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps drawProps, Color color) {
            IPrimProps.Face props = new IPrimProps.Face(color, null, 2);
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this), (IPrimProps)props);
        }
    }

    public static final class Rectangle
    extends AARectangle
    implements IStatGeom {
        static final long serialVersionUID = 1L;

        public Rectangle(AARectangle baseRect) {
            super(baseRect.d_plane, baseRect.d_planeVal, baseRect.d_minx, baseRect.d_miny, baseRect.d_maxx, baseRect.d_maxy, baseRect.flipped);
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof Rectangle && super.equals(obj);
        }

        @Override
        public boolean surrogateEquals(IStatGeom geom) {
            return this.equals(geom);
        }

        @Override
        public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public int getNumPoints() {
            return 1;
        }

        @Override
        public ArrayProfile getArrayProfile() {
            return null;
        }

        @Override
        public Type getType() {
            return Type.RECTANGLE;
        }

        @Override
        public AARectangle modify(AARectangle r) {
            return new Rectangle(r);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps drawProps, Color color) {
            IPrimProps.Face props = new IPrimProps.Face(color, null, 0);
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this), (IPrimProps)props);
        }
    }

    public static final class Point
    extends thunderheadeng.geometry.objs.Point
    implements IStatGeom {
        static final long serialVersionUID = 1L;

        public Point(Point3d location) {
            super(location);
        }

        @Override
        public boolean surrogateEquals(IStatGeom geom) {
            return this.equals(geom);
        }

        @Override
        public int getNumPoints() {
            return 1;
        }

        @Override
        public ArrayProfile getArrayProfile() {
            return null;
        }

        @Override
        public Type getType() {
            return Type.POINT;
        }

        @Override
        public Stream<DependencyInfo<? extends IPyroObject>> streamDependencies() {
            return Stream.empty();
        }

        @Override
        public thunderheadeng.geometry.objs.Point newPoint(Point3d loc) {
            return new Point(loc);
        }

        @Override
        public DisplayGeom getDisplayGeom(IDisplayProps drawProps, Color color) {
            IPrimProps.Vertex props = new IPrimProps.Vertex(color, 10.0);
            return new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(this), (IPrimProps)props);
        }
    }

    public record DependencyInfo<T extends IPyroObject>(Class<T> type, BiConsumer<StatisticsDevc, DepList> takeSnapshot, TriConsumer<StatisticsDevc, T, Set<T>> removeInvalidRepl, TriFunction<StatisticsDevc, T, T, IStatGeom> replaceDep) {
    }

    public static enum SpatialType {
        VOLUME,
        AREA;

    }
}

