/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.sprayers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IImprintable;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.ASprayer;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.signals.AOutPin;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.SignalsUtil;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Sprinkler
extends ASprayer
implements IDirectDependent,
IFreezable {
    static final long serialVersionUID = 1L;
    private LinkModel d_linkModel;
    private DryPipe d_dryPipe;
    private LogicOutPin d_linkAlarmPin;
    private IDoubleOutPin d_linkQuantityPin;
    private OneLogicInPin d_freezePin;

    public Sprinkler(String name, SprayModel sprayDesc, LinkModel linkModel, FreePointLoc loc) {
        super(name, sprayDesc, loc);
        this.d_linkModel = linkModel;
        this.d_freezePin = new OneLogicInPin(this);
        this.initPins();
    }

    private void initPins() {
        this.d_linkAlarmPin = new LogicOutPin(this, Intl.intl("LINK"));
        this.d_linkQuantityPin = new LinkQuantOutPin(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_linkAlarmPin == null) {
            assert (this.d_linkQuantityPin == null);
            this.initPins();
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Sprinkler)) {
            return false;
        }
        Sprinkler sprk = (Sprinkler)obj;
        return super.equals(obj) && this.d_linkModel.equals(sprk.d_linkModel) && Objects.equals(this.d_dryPipe, sprk.d_dryPipe) && this.d_freezePin.equals(sprk.d_freezePin);
    }

    @Override
    public Sprinkler clone() {
        Sprinkler sprk = (Sprinkler)super.clone();
        sprk.d_linkAlarmPin = this.d_linkAlarmPin.clone(sprk);
        sprk.d_linkQuantityPin = (IDoubleOutPin)this.d_linkQuantityPin.clone(sprk);
        sprk.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(sprk);
        return sprk;
    }

    @Override
    public List<? extends IOutPin> getOutputPins() {
        ArrayList<? extends IOutPin> pins = new ArrayList<IOutPin>(super.getOutputPins());
        pins.add(this.d_linkAlarmPin);
        pins.add(this.d_linkQuantityPin);
        return pins;
    }

    public LogicOutPin getLinkAlarmPin() {
        return this.d_linkAlarmPin;
    }

    public IDoubleOutPin getLinkQuantityPin() {
        return this.d_linkQuantityPin;
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    public DryPipe getDryPipe() {
        return this.d_dryPipe;
    }

    public void setDryPipe(DryPipe pipe) {
        this.d_dryPipe = pipe;
        this.changedEvt(new Object[0]);
    }

    public LinkModel getLinkModel() {
        return this.d_linkModel;
    }

    public void setLinkModel(LinkModel linkModel, Unit newUnit) {
        if (this.d_linkModel == linkModel) {
            return;
        }
        IQuantity oldQuant = this.d_linkModel.getOutputQuantity();
        this.d_linkModel = linkModel;
        IQuantity newQuant = this.d_linkModel.getOutputQuantity();
        if (!oldQuant.equals(newQuant) && this.getDomain() != null) {
            DepSnapshot ds = ((PyroMod)this.getDomain()).getDependencies(this);
            Set<Dependency> deps = ds.getDependents(this);
            for (Dependency dep : deps) {
                if (!(dep.source instanceof IDoubleInPin)) continue;
                IDoubleInPin pin = (IDoubleInPin)dep.source;
                pin.updateInputUnit(newUnit);
            }
        }
        this.changedEvt(new Object[0]);
    }

    public Task taskSetLinkModel(LinkModel linkModel, final Unit newUnit) {
        return new AReplaceRefTask<LinkModel>((Object)this.d_linkModel, (Object)linkModel){

            @Override
            protected void set(LinkModel obj) {
                Sprinkler.this.setLinkModel(obj, newUnit);
            }
        };
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        if (this.d_linkModel instanceof TraditionalModel) {
            deps.add(DLink.STRONG, (IPyroObject)((TraditionalModel)this.d_linkModel).d_link);
        } else {
            QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        deps.add(DLink.WEAK, (IPyroObject)this.d_dryPipe);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof SprinklerLinkModel) {
            Util.keepIfNullOr(objs, SprinklerLinkModel.class);
        } else if (old instanceof DryPipe) {
            Util.keepIfNullOr(objs, DryPipe.class);
        } else if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(old, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer replacer = new QuantReplacer();
            replacer.removeInvalidReplacements(old, objs, ((QuantityModel)this.d_linkModel).d_quantity);
        }
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof SprinklerLinkModel) {
            assert (replacement != null);
            TraditionalModel newModel = new TraditionalModel((SprinklerLinkModel)replacement);
            return this.taskSetLinkModel(newModel, SIUS.unit(((LinkModel)newModel).getOutputQuantity().get().unitType));
        }
        if (old instanceof DryPipe) {
            return new AReplaceRefTask<DryPipe>((Object)old, (Object)replacement){

                @Override
                protected void set(DryPipe obj) {
                    Sprinkler.this.setDryPipe(obj);
                }
            };
        }
        if (this.d_linkModel instanceof QuantityModel && QuantityUtil.isQuantityRef(old, ((QuantityModel)this.d_linkModel).d_quantity)) {
            QuantReplacer replacer = new QuantReplacer();
            return replacer.taskReplaceDep(old, replacement, ((QuantityModel)this.d_linkModel).d_quantity);
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new Sprinkler(this.getName(), (SprayModel)this.getSprayModel().clone(), this.getLinkModel(), this.getLocation()), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        Sprinkler refSprinker = (Sprinkler)refObject;
        this.d_linkModel = refSprinker.getLinkModel();
        this.setDryPipe(refSprinker.getDryPipe());
        this.d_linkAlarmPin = refSprinker.getLinkAlarmPin().clone(this);
        this.d_linkQuantityPin = (IDoubleOutPin)refSprinker.getLinkQuantityPin().clone(this);
        this.d_freezePin = (OneLogicInPin)refSprinker.d_freezePin.clone(this);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public static abstract class LinkModel
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final boolean d_initState;
        public final boolean d_latch;

        public LinkModel(boolean initState, boolean latch) {
            this.d_initState = initState;
            this.d_latch = latch;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof LinkModel)) {
                return false;
            }
            LinkModel model = (LinkModel)obj;
            return this.d_initState == model.d_initState && this.d_latch == model.d_latch;
        }

        public int hashCode() {
            return 9602042 + theUtil.hashCode(this.d_initState) + theUtil.hashCode(this.d_latch);
        }

        public abstract IQuantity getOutputQuantity();
    }

    public static class LinkQuantOutPin
    extends AOutPin
    implements IDoubleOutPin {
        static final long serialVersionUID = 1L;

        public LinkQuantOutPin(Sprinkler sprinkler) {
            super(sprinkler, Intl.intl("LINK"));
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && obj instanceof LinkQuantOutPin;
        }

        @Override
        public void setSource(ISignalSource source) {
            assert (source instanceof Sprinkler);
            super.setSource(source);
        }

        @Override
        public void restoreFrom(IOutPin pin) {
        }

        public Sprinkler getSprinkler() {
            return (Sprinkler)this.getAttachedSource();
        }

        @Override
        public int getUnitType() {
            return this.getSprinkler().getLinkModel().getOutputQuantity().get().unitType;
        }
    }

    public static class TraditionalModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final SprinklerLinkModel d_link;

        public TraditionalModel(SprinklerLinkModel link) {
            this(link, false, true);
        }

        public TraditionalModel(SprinklerLinkModel link, boolean initState, boolean latch) {
            super(initState, latch);
            this.d_link = link;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof TraditionalModel && this.d_link.equals(((TraditionalModel)obj).d_link);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 864318175 + this.d_link.hashCode();
        }

        @Override
        public IQuantity getOutputQuantity() {
            return Quantity.TEMPERATURE.create();
        }
    }

    public static class QuantityModel
    extends LinkModel {
        static final long serialVersionUID = 1L;
        public final IQuantity d_quantity;
        public final UnitDouble d_setPoint;

        public QuantityModel(IQuantity quantity, UnitDouble setPoint) {
            this(quantity, setPoint, false, true);
        }

        public QuantityModel(IQuantity quantity, UnitDouble setPoint, boolean initState, boolean latch) {
            super(initState, latch);
            this.d_quantity = quantity;
            this.d_setPoint = setPoint;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof QuantityModel)) {
                return false;
            }
            QuantityModel mod = (QuantityModel)obj;
            return this.d_quantity.equals(mod.d_quantity) && this.d_setPoint.equals(mod.d_setPoint);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 1647607715 + this.d_quantity.hashCode() + this.d_setPoint.hashCode();
        }

        public static long getOutputType() {
            return 1L;
        }

        public static QuantityType getQuantityType() {
            return QuantityType.GAS;
        }

        public static Predicate<Quantity> getQuantityFilter() {
            return new QuantityUtil.TypeFilter(QuantityModel.getOutputType(), new QuantityType[]{QuantityModel.getQuantityType()}){

                @Override
                public boolean test(Quantity o) {
                    return o == Quantity.TIME || super.test(o);
                }
            };
        }

        @Override
        public IQuantity getOutputQuantity() {
            return this.d_quantity;
        }
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)Sprinkler.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            Unit newUnit;
            assert (newMsr != null);
            QuantityModel oldMod = (QuantityModel)Sprinkler.this.d_linkModel;
            Unit oldUnit = oldMod.d_setPoint.getUnit();
            UnitDouble newsp = SignalsUtil.areCompatible(oldUnit, newUnit = SIUS.unit(newMsr.get().unitType)) ? oldMod.d_setPoint : new UnitDouble(oldMod.d_setPoint.getValueNoUnit(), newUnit);
            QuantityModel newModel = new QuantityModel(newMsr, newsp);
            return Sprinkler.this.taskSetLinkModel(newModel, newUnit);
        }
    }
}

