/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.jscience.physics.units.SI;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class Thermocouple
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_beadDiameter;
    private double d_emissivity;
    private UnitDouble d_beadDensity;
    private UnitDouble d_beadSpecHeat;

    public Thermocouple(String name, FreePointLoc loc) {
        this(name, new UnitDouble(0.001, SI.METER), 0.85, SIUS.newud(8908.0, 4), SIUS.newud(0.44, 11), loc);
    }

    public Thermocouple(String name, UnitDouble beadDiameter, double emissivity, UnitDouble beadDensity, UnitDouble beadSpecHeat, FreePointLoc loc) {
        super(name, Quantity.THERMOCOUPLE.create(), loc);
        this.d_beadDiameter = beadDiameter;
        this.d_emissivity = emissivity;
        this.d_beadDensity = beadDensity;
        this.d_beadSpecHeat = beadSpecHeat;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Thermocouple)) {
            return false;
        }
        Thermocouple thcp = (Thermocouple)obj;
        return super.equals(obj) && this.d_emissivity == thcp.d_emissivity && this.d_beadDiameter.equals(thcp.d_beadDiameter) && this.d_beadDensity.equals(thcp.d_beadDensity) && this.d_beadSpecHeat.equals(thcp.d_beadSpecHeat);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(in) < 38) {
            this.d_beadDensity = SIUS.newud(8908.0, 4);
            this.d_beadSpecHeat = SIUS.newud(0.44, 11);
        }
    }

    public void setBeadDiameter(UnitDouble diameter) {
        this.d_beadDiameter = diameter;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadDiameter() {
        return this.d_beadDiameter;
    }

    public void setEmissivity(double emiss) {
        this.d_emissivity = emiss;
        this.changedEvt(new Object[0]);
    }

    public double getEmissivity() {
        return this.d_emissivity;
    }

    public void setBeadDensity(UnitDouble density) {
        this.d_beadDensity = density;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadDensity() {
        return this.d_beadDensity;
    }

    public void setBeadSpecHeat(UnitDouble specHeat) {
        this.d_beadSpecHeat = specHeat;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getBeadSpecHeat() {
        return this.d_beadSpecHeat;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new Thermocouple(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        Thermocouple therm = (Thermocouple)refObject;
        this.setBeadDiameter(therm.getBeadDiameter());
        this.setEmissivity(therm.getEmissivity());
        this.setBeadDensity(therm.getBeadDensity());
        this.setBeadSpecHeat(therm.getBeadSpecHeat());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

