/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import pyrosim.domain.IImprintable;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;

public class SolidDensityMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_depth;

    public SolidDensityMeasurer(String name, ObjectQuantity<Material> measurement, AttachedPointLoc loc) {
        this(name, measurement, new UnitDouble(0.0, SI.METER), loc);
    }

    public SolidDensityMeasurer(String name, ObjectQuantity<Material> measurement, UnitDouble depth, AttachedPointLoc loc) {
        super(name, measurement, loc);
        this.d_depth = depth;
        assert (measurement.get() == Quantity.MATL_SOLID_DENSITY);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SolidDensityMeasurer && super.equals(obj) && this.d_depth.equals(((SolidDensityMeasurer)obj).d_depth);
    }

    public static Predicate<Quantity> getQuantityFilter() {
        return Filters.accept(Quantity.MATL_SOLID_DENSITY);
    }

    public UnitDouble getDepth() {
        return this.d_depth;
    }

    public void setDepth(UnitDouble depth) {
        this.d_depth = depth;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IDevice getRestoreObject() {
        Material m1 = new Material("m1");
        return IImprintable.imprintOn(new SolidDensityMeasurer(this.getName(), Quantity.MATL_SOLID_DENSITY.create(m1), new AttachedPointLoc()), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        SolidDensityMeasurer sdDev = (SolidDensityMeasurer)refObject;
        this.setDepth(sdDev.getDepth());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

