/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class PressureCoeffMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_charVel;

    public PressureCoeffMeasurer(String name, AttachedPointLoc loc) {
        this(name, SIUS.newud(1.0, 8), loc);
    }

    public PressureCoeffMeasurer(String name, UnitDouble characteristicVelocity, AttachedPointLoc loc) {
        super(name, Quantity.PRESSURE_COEFFICIENT.create(), loc);
        this.d_charVel = characteristicVelocity;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PressureCoeffMeasurer && super.equals(obj) && this.d_charVel.equals(((PressureCoeffMeasurer)obj).d_charVel);
    }

    public void setCharacteristicVel(UnitDouble vel) {
        this.d_charVel = vel;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getCharacteristicVel() {
        return this.d_charVel;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new PressureCoeffMeasurer(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        PressureCoeffMeasurer pcDev = (PressureCoeffMeasurer)refObject;
        this.setCharacteristicVel(pcDev.getCharacteristicVel());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

