/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.IBeamDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.SignalsUtil;
import pyrosim.geom.Geometry;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitLineSeg3D;

public class LayerMeasurer
extends ASourceDevice
implements IBeamDevice,
IMeasurer {
    static final long serialVersionUID = 1L;
    public static final String HEIGHT_ID = Intl.intl("HEIGHT");
    public static final String LOWERTEMP_ID = Intl.intl("LTEMP");
    public static final String UPPERTEMP_ID = Intl.intl("UTEMP");
    private UnitLineSeg3D d_beam;
    private MeasureOutInfo d_height;
    private MeasureOutInfo d_upperTemp;
    private MeasureOutInfo d_lowerTemp;
    private OneLogicInPin d_freezePin;
    private static final IPrimProps s_primProps = new IPrimProps.Edge(new Color(0.7f, 0.7f, 0.0f), 1.0, IPrimProps.DEF_STIPPLE, 0);

    public LayerMeasurer(String name) {
        this(name, true, false, false, new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 3.0, SI.METER));
    }

    public LayerMeasurer(String name, boolean measureHeight, boolean measureUpperTemp, boolean measureLowerTemp, UnitLineSeg3D beam) {
        super(name);
        this.d_beam = beam;
        this.d_height = new MeasureOutInfo(this, measureHeight, new LayerPin((ISignalSource)this, HEIGHT_ID, Quantity.LAYER_HEIGHT.create()), Intl.intl("HT_ALARM"));
        this.d_upperTemp = new MeasureOutInfo(this, measureUpperTemp, new LayerPin((ISignalSource)this, UPPERTEMP_ID, Quantity.UPPER_TEMPERATURE.create()), Intl.intl("UT_ALARM"));
        this.d_lowerTemp = new MeasureOutInfo(this, measureLowerTemp, new LayerPin((ISignalSource)this, LOWERTEMP_ID, Quantity.LOWER_TEMPERATURE.create()), Intl.intl("LT_ALARM"));
        this.d_freezePin = new OneLogicInPin(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public Object clone() {
        LayerMeasurer clone = (LayerMeasurer)super.clone();
        clone.d_height = (MeasureOutInfo)this.d_height.clone(clone);
        clone.d_upperTemp = (MeasureOutInfo)this.d_upperTemp.clone(clone);
        clone.d_lowerTemp = (MeasureOutInfo)this.d_lowerTemp.clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof LayerMeasurer)) {
            return false;
        }
        LayerMeasurer layer = (LayerMeasurer)obj;
        return super.equals(obj) && this.d_height.equals(layer.d_height) && this.d_lowerTemp.equals(layer.d_lowerTemp) && this.d_upperTemp.equals(layer.d_upperTemp) && this.d_beam.equals(layer.d_beam) && this.d_freezePin.equals(layer.d_freezePin);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        if (pin == this.d_height.getAlarmPin()) {
            return this.d_height.latches();
        }
        if (pin == this.d_upperTemp.getAlarmPin()) {
            return this.d_upperTemp.latches();
        }
        if (pin == this.d_lowerTemp.getAlarmPin()) {
            return this.d_lowerTemp.latches();
        }
        return false;
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public int getNumMeasurements() {
        return 3;
    }

    @Override
    public IQuantity getQuantity(int ix) {
        switch (ix) {
            case 0: {
                return Quantity.LAYER_HEIGHT.create();
            }
            case 1: {
                return Quantity.LOWER_TEMPERATURE.create();
            }
            case 2: {
                return Quantity.UPPER_TEMPERATURE.create();
            }
        }
        return null;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int ix) {
        switch (ix) {
            case 0: {
                return this.d_height;
            }
            case 1: {
                return this.d_lowerTemp;
            }
            case 2: {
                return this.d_upperTemp;
            }
        }
        return null;
    }

    public MeasureOutInfo getHeightInfo() {
        return this.d_height;
    }

    public MeasureOutInfo getLowerTempInfo() {
        return this.d_lowerTemp;
    }

    public MeasureOutInfo getUpperTempInfo() {
        return this.d_upperTemp;
    }

    public void setHeight(boolean height) {
        this.pauseUpdates();
        if (!height) {
            this.d_height.disconnectPins();
        }
        this.d_height.setEnabled(height);
        this.resumeUpdates();
    }

    public void setLowerTemp(boolean lowerTemp) {
        this.pauseUpdates();
        if (!lowerTemp) {
            this.d_lowerTemp.disconnectPins();
        }
        this.d_lowerTemp.setEnabled(lowerTemp);
        this.resumeUpdates();
    }

    public void setUpperTemp(boolean upperTemp) {
        this.pauseUpdates();
        if (!upperTemp) {
            this.d_upperTemp.disconnectPins();
        }
        this.d_upperTemp.setEnabled(upperTemp);
        this.resumeUpdates();
    }

    public boolean measureHeight() {
        return this.d_height.isEnabled();
    }

    public boolean measureLowerTemp() {
        return this.d_lowerTemp.isEnabled();
    }

    public boolean measureUpperTemp() {
        return this.d_upperTemp.isEnabled();
    }

    public void setBeam(UnitLineSeg3D beam) {
        this.d_beam = beam;
        this.changedEvt(new Object[0]);
    }

    @Override
    public UnitLineSeg3D getBeam() {
        return this.d_beam;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return new DisplayGeom(this.getGeom(), s_primProps);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getLayerGeom());
    }

    public IGeom getLayerGeom() {
        return new LineSeg(this.d_beam.getP1(Geometry.LU), this.d_beam.getP2(Geometry.LU));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof LineSeg) {
            LineSeg ls = (LineSeg)geom;
            this.setBeam(new UnitLineSeg3D(ls.p1, ls.p2, Geometry.LU));
        }
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new LayerMeasurer(this.getName()), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        LayerMeasurer refMeasuerer = (LayerMeasurer)refObject;
        this.setBeam(refMeasuerer.getBeam());
        this.getHeightInfo().restoreFrom(refMeasuerer.getHeightInfo());
        this.getUpperTempInfo().restoreFrom(refMeasuerer.getUpperTempInfo());
        this.getLowerTempInfo().restoreFrom(refMeasuerer.getLowerTempInfo());
        SignalsUtil.restoreInPin(this, this.getFreezePin(), refMeasuerer.getFreezePin());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public static class LayerPin
    extends DoubleOutPin {
        static final long serialVersionUID = 5796923347439345807L;
        public final IQuantity d_measurement;

        public LayerPin(ISignalSource src, String name, IQuantity msr) {
            super(src, name, msr.get().unitType);
            this.d_measurement = msr;
        }

        @Override
        public boolean equals(Object obj) {
            return obj instanceof LayerPin && super.equals(obj) && this.d_measurement.equals(((LayerPin)obj).d_measurement);
        }

        @Override
        public int hashCode() {
            return super.hashCode() + -1719520006 + this.d_measurement.hashCode();
        }
    }
}

