/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.util.Set;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.ISourceDevice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.unitsystem.SIUS;

public interface IUpdatableSourceDevice
extends ISourceDevice {
    public int getUnitType();

    public void setQuantity(IQuantity var1);

    private Unit interpretUnit(int newUnitType) {
        return PyroSim.getAppOpt().map(app -> app.getUnitSystem().getUnit(newUnitType)).orElse(SIUS.unit(newUnitType));
    }

    default public void updateDownstreamUnits() {
        if (this.getDomain() == null) {
            return;
        }
        Unit newUnit = this.interpretUnit(this.getUnitType());
        DepSnapshot ds = ((PyroMod)this.getDomain()).getDependencies(this);
        Set<Dependency> deps = ds.getDependents(this);
        for (Dependency dep : deps) {
            IDirectDependent iDirectDependent = dep.source;
            if (!(iDirectDependent instanceof IDoubleInPin)) continue;
            IDoubleInPin pin = (IDoubleInPin)iDirectDependent;
            pin.updateInputUnit(newUnit);
        }
    }
}

