/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class GaugeHeatFluxMeasurer
extends SolidPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_gaugeTemperature;
    private UnitDouble d_heatTransferCoeff;
    private double d_gaugeEmissivity;

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, AttachedPointLoc loc) {
        this(name, gaugeTemperature, 1.0, null, loc);
    }

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, double gaugeEmissivity, AttachedPointLoc loc) {
        this(name, gaugeTemperature, gaugeEmissivity, null, loc);
    }

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, UnitDouble heatTransferCoefficient, AttachedPointLoc loc) {
        this(name, gaugeTemperature, 1.0, heatTransferCoefficient, loc);
    }

    public GaugeHeatFluxMeasurer(String name, UnitDouble gaugeTemperature, double gaugeEmissivity, UnitDouble heatTransferCoefficient, AttachedPointLoc loc) {
        super(name, Quantity.GAUGE_HEAT_FLUX.create(), loc);
        this.d_gaugeTemperature = gaugeTemperature;
        this.d_gaugeEmissivity = gaugeEmissivity;
        this.d_heatTransferCoeff = heatTransferCoefficient;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GaugeHeatFluxMeasurer && super.equals(obj) && theUtil.equal(this.d_gaugeTemperature, ((GaugeHeatFluxMeasurer)obj).d_gaugeTemperature) && theUtil.equal(this.d_gaugeEmissivity, ((GaugeHeatFluxMeasurer)obj).d_gaugeEmissivity) && theUtil.equal(this.d_heatTransferCoeff, ((GaugeHeatFluxMeasurer)obj).d_heatTransferCoeff);
    }

    public void setGaugeTemperature(UnitDouble temp) {
        this.d_gaugeTemperature = temp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setGaugeEmissivity(double emiss) {
        this.d_gaugeEmissivity = emiss;
        this.changedEvt(new Object[0]);
    }

    public double getGaugeEmissivity() {
        return this.d_gaugeEmissivity;
    }

    public void setHeatTransferCoefficient(UnitDouble coeff) {
        this.d_heatTransferCoeff = coeff;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getHeatTransferCoefficient() {
        return this.d_heatTransferCoeff;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new GaugeHeatFluxMeasurer(this.getName(), null, null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        GaugeHeatFluxMeasurer ghfDev = (GaugeHeatFluxMeasurer)refObject;
        this.setGaugeTemperature(ghfDev.getGaugeTemperature());
        this.setHeatTransferCoefficient(ghfDev.getHeatTransferCoefficient());
        this.setGaugeEmissivity(ghfDev.getGaugeEmissivity());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

