/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import pyrosim.domain.IImprintable;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class GaugeHeatFluxGasMeasurer
extends GasPointMeasurer {
    static final long serialVersionUID = 1L;
    private UnitDouble d_gaugeTemperature;
    private UnitDouble d_heatTransferCoeff;

    public GaugeHeatFluxGasMeasurer(String name, FreePointLoc loc) {
        this(name, null, null, loc);
    }

    public GaugeHeatFluxGasMeasurer(String name, UnitDouble gaugeTemperature, UnitDouble heatTransferCoefficient, FreePointLoc loc) {
        super(name, Quantity.GAUGE_HEAT_FLUX_GAS.create(), loc);
        this.d_heatTransferCoeff = heatTransferCoefficient;
        this.d_gaugeTemperature = gaugeTemperature;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof GaugeHeatFluxGasMeasurer && super.equals(obj) && theUtil.equal(this.d_gaugeTemperature, ((GaugeHeatFluxGasMeasurer)obj).d_gaugeTemperature) && theUtil.equal(this.d_heatTransferCoeff, ((GaugeHeatFluxGasMeasurer)obj).d_heatTransferCoeff);
    }

    public void setGaugeTemperature(UnitDouble temp) {
        this.d_gaugeTemperature = temp;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getGaugeTemperature() {
        return this.d_gaugeTemperature;
    }

    public void setHeatTransferCoefficient(UnitDouble htc) {
        this.d_heatTransferCoeff = htc;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getHeatTransferCoefficient() {
        return this.d_heatTransferCoeff;
    }

    @Override
    public IDevice getRestoreObject() {
        return IImprintable.imprintOn(new GaugeHeatFluxGasMeasurer(this.getName(), null), this);
    }

    @Override
    public void imprint(IDevice refObject) {
        this.pauseUpdates();
        super.imprint(refObject);
        GaugeHeatFluxGasMeasurer gmDev = (GaugeHeatFluxGasMeasurer)refObject;
        this.setGaugeTemperature(gmDev.getGaugeTemperature());
        this.setHeatTransferCoefficient(gmDev.getHeatTransferCoefficient());
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }
}

